﻿;Copyright 2007-2015 John T. Haller of PortableApps.com
;Website: http://PortableApps.com/

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

;EXCEPTION: The PortableApps.com Installer can be used with open source
;applications licensed under OSI-approved licenses as well as freeware provided
;it is unmodified and it adheres to the current PortableApps.com Format Specification
;as published at PortableApps.com/development. It may also be used with commercial
;software by contacting PortableApps.com.

!define PORTABLEAPPSINSTALLERVERSION "3.0.20.0"
!define PORTABLEAPPS.COMFORMATVERSION "3.0.20"

!if ${__FILE__} == "PortableApps.comInstallerPlugin.nsi"
	!include PortableApps.comInstallerPluginConfig.nsh
	!define PLUGININSTALLER
!else
	!include PortableApps.comInstallerConfig.nsh
!endif

# MANiFEST
!define RequestLevel USER
!define ResHacker    `${NSISDIR}\Contrib\Manifests\ResHacker.exe`
!define ManifDir     `${NSISDIR}\Contrib\Manifests`
!define Manifest     `NSIS_2.46_Win8`
!packhdr             `$%TEMP%\exehead.tmp` `"${Reshacker}" -addoverwrite "%TEMP%\exehead.tmp", "%TEMP%\exehead.tmp", "${ManifDir}\${Manifest}_${RequestLevel}.manifest", 24,1,1033`

# iNCLUDE (moved here so it's easier to see)
;!define Check64                 ;=== check x64 minreq
;!define Include_x64.nsh
!define Include_WinVer.nsh
;!define Include_GetBetween.nsh
;!define Include_ReplaceInFileWithTextReplace.nsh
;!define Include_LineWrite.nsh
;!define Include_ProcFunc.nsh
;!define ExtractionOnly           ;=== enables $CMD variable
;!define COMMONFILESPLUGIN       ;=== set COMMONFILES plugin
;!define BrowserPlugin           ;=== set description for Browser Plugin
;!define NON-SPECIFIC-PLUGIN     ;=== for Browser Plugins which support multiple apps.
;!define PLUGINSELECTION         ;=== enable Optional Components Page for Plugin.
;!define SHOWMAINSECTIONTITLE    ;=== show MainSectionTitle as option
;!define CUSTOMSIZE              ;=== enable custom sizes
!define DISABLE_FINISH_RUN       ;=== uncomment for apps. which require Admin. Rights.
;!define XML_PLUGIN              ;=== enable XML functio
;!define CompareFileVersion       ;=== compare file versions
;!define Registry                 ;=== enable Registry plugin.
;!define FORCEONLYONESELECTION   ;=== force only 1 selection
;!define UAC                      ;=== enable UAC elevation.
;!define DISABLE_BACKUP           ;=== disable installer.ini Backup Scheme.

# DotNet
;!define CheckNET 4.0            ;=== specify .NET Version to check for. ie. !define CheckNET 2.0, !define CheckNET 3.5, etc.
!ifdef CheckNET
	!if ${CheckNET} == ""
		!define CheckHasDotNetFramework
	!else
		!define Include_DotNetVer.nsh
	!endif
!endif

# TESTiNG
;!define NOCOMPRESSION

# DEFiNE
!define VER        1.0.6
!define BUILD      ${VER}.0
!define APP        Windows10Manager
;!define APP64      
!define FULLNAME   `Windows 10 Manager`
!define APPDIR     `$INSTDIR\App\${APP}`
!define APPDIR64   `$INSTDIR\App\${APP64}`
!define APPNAME    `${APP}Portable`
!define APPINFO    `$INSTDIR\App\AppInfo`
!define LAUNCHER   `${APPINFO}\Launcher`
!define DATA       `$INSTDIR\Data`
!define DEFDATA    `$INSTDIR\App\DefaultData`
!define DEFSET     `${DEFDATA}\settings`
!define SET        `$INSTDIR\Data\settings`
!define OTHER      `$INSTDIR\Other`
;!define PLUGIN     ;=== check for presence of dependency.
!define BRANDING   Yamicsoft
!define EXE        `$INSTDIR\${APPNAME}.exe`
!define LEGAL      `Copyright 2012 - 2015.`
;!define Trademarks 
!define INI        `$INSTDIR\Backup_log.ini`
!define INS        `${APPINFO}\installer.ini`

# VARiABLE
!ifndef PLUGININSTALLER
	var ADDITIONALPARAMETERS
	var RUNLOCALLY
	var BANNER
!endif

!ifdef ExtractionOnly
	var CMD
!endif
!ifdef Include_GetBetween.nsh
	var VERSION
!endif
!ifdef DownloadURL
	!define SETOUTDIR `$PLUGINSDIR`
!endif
!ifdef Check64
	!ifndef Include_x64.nsh
		!define Include_x64.nsh
	!endif
!endif
!ifdef PLUGINSELECTION
	!define MAINSECTIONTITLE
!endif
!ifdef UAC
	Var RunAsAdmin
!endif

# SECTiON
!define MAINSECTIONIDX 0
!ifdef MAINSECTIONTITLE
	!define SECTION_ON ${SF_SELECTED}
	!include Sections.nsh
;	!define FORCE_SELECTION    ;=== force user to make a selection
	;===
;	!define OPTIONALSECTION1 1 ;=== define to enable
;	!define OPTIONALSECTION2 2 ;=== define to enable
;	!define OPTIONALSECTION3 3 ;=== define to enable
;	!define OPTIONALSECTION4 4 ;=== define to enable
;	!define OPTIONALSECTION5 5 ;=== define to enable
;	!define OPTIONALSECTION6 6 ;=== define to enable
	;===
	!ifdef CUSTOMSIZE
;		!define DEFAULTSIZE 0
;		!define 3264LANG    2676186
;		!define 32LANG      1223160
;		!define 64LANG      1465098
;		!define 3264        2254401
;		!define 32          1012137
;		!define 64          1254076
	!endif
	!ifdef OPTIONALSECTION1
		var SECTION1
		!ifndef CUSTOMSIZE
			!define DEFAULTSIZE           0
			!define OPTIONALSECTION1SIZE  0
		!endif
		!define OPTIONALSECTION1TITLE     `${APP} x86 (32-bit)`
	!endif
	!ifdef OPTIONALSECTION2
		var SECTION2
		var FILE2
		var URL2
		!ifndef CUSTOMSIZE
			!define OPTIONALSECTION2SIZE  0
		!endif
		!define OPTIONALSECTION2TITLE     `${APP} x64 (64-bit)`
	!endif
	!ifdef OPTIONALSECTION3
		var SECTION3
		!ifndef CUSTOMSIZE
;			!define OPTIONALSECTION3SIZE  0
		!endif
		!define OPTIONALSECTION3TITLE     Multilingual
	!endif
	!ifdef OPTIONALSECTION4
		var SECTION4
		!ifndef CUSTOMSIZE
;			!define OPTIONALSECTION4SIZE  0
		!endif
		!define OPTIONALSECTION4TITLE     ""
	!endif
	!ifdef OPTIONALSECTION5
		var SECTION5
		!ifndef CUSTOMSIZE
			!define OPTIONALSECTION5SIZE  0
		!endif
		!define OPTIONALSECTION5TITLE     ""
	!endif
	!ifdef OPTIONALSECTION6
		var SECTION6
		!ifndef CUSTOMSIZE
			!define OPTIONALSECTION6SIZE  0
		!endif
		!define OPTIONALSECTION6TITLE     ""
	!endif
!endif

# SPECiFiCATIONS
Name "${PORTABLEAPPNAME}" "${PORTABLEAPPNAMEDOUBLEDAMPERSANDS}"
OutFile "..\..\..\${FILENAME}.paf.exe"
!ifdef NON-SPECIFIC-PLUGIN
	!ifdef COMMONFILESPLUGIN
		InstallDir "\CommonFiles"
	!else
		InstallDir ""
	!endif
!else
	!ifdef COMMONFILESPLUGIN
		InstallDir "\CommonFiles\${APPID}"
	!else
		InstallDir "\${APPID}"
	!endif
!endif
Caption                          `${FULLNAME}`
VIProductVersion                 `${BUILD}`
VIAddVersionKey ProductName      `${FULLNAME}`
VIAddVersionKey Comments         http://portablewares.blogspot.com/
VIAddVersionKey CompanyName      `${BRANDING}`
VIAddVersionKey LegalCopyright   `${LEGAL}`
VIAddVersionKey FileDescription  `${FULLNAME}`
VIAddVersionKey FileVersion      `${BUILD}`
VIAddVersionKey ProductVersion   Portable
VIAddVersionKey InternalName     `${PORTABLEAPPNAME}`
!ifdef Trademarks
	VIAddVersionKey LegalTrademarks  `${Trademarks}`
!endif
VIAddVersionKey OriginalFilename "${FILENAME}.paf.exe"
VIAddVersionKey PortableApps.comInstallerVersion "${PORTABLEAPPSINSTALLERVERSION}"
VIAddVersionKey PortableApps.comFormatVersion "${PORTABLEAPPS.COMFORMATVERSION}"
VIAddVersionKey PortableApps.comAppID "${APPID}"
!ifdef DownloadURL ;advertise the needed bits to the PA.c Updater
	VIAddVersionKey PortableApps.comDownloadURL "${DownloadURL}"
	VIAddVersionKey PortableApps.comDownloadKnockURL "${DownloadKnockURL}"
	VIAddVersionKey PortableApps.comDownloadName "${DownloadName}"
	VIAddVersionKey PortableApps.comDownloadFileName "${DownloadFileName}"
	VIAddVersionKey PortableApps.comDownloadMD5 "${DownloadMD5}"
!endif

!ifdef NOCOMPRESSION
	SetCompress off
!else
	SetCompress Auto
	SetCompressor /SOLID lzma
	SetCompressorDictSize 32
	SetDatablockOptimize On
!endif

CRCCheck on
AutoCloseWindow True
RequestExecutionLevel user
AllowRootDirInstall true

;=== CUSTOM iNCLUDES
!ifdef Include_x64.nsh
	!include x64.nsh
!endif
!ifdef Check64
	!ifndef Include_x64.nsh
		!include x64.nsh
	!endif
!endif
!ifdef Include_WinVer.nsh
	!include WinVer.nsh
!endif
!ifdef Include_GetBetween.nsh
	!include GetBetween.nsh
!endif
!ifdef Include_ReplaceInFileWithTextReplace.nsh
	!include ReplaceInFileWithTextReplace.nsh
!endif
!ifdef Include_LineWrite.nsh
	!include LineWrite.nsh
!endif
!ifdef Include_DotNetVer.nsh
	!include DotNetVer.nsh
!endif
!ifdef Include_ProcFunc.nsh
	!include ProcFunc.nsh
!endif
!ifdef UAC
	!include UAC.nsh
!endif
;=== Include
!include MUI2.nsh
!include FileFunc.nsh
!include LogicLib.nsh
!ifdef PRESERVEFILE1
	!include PortableApps.comInstallerMoveFiles.nsh
!endif
!ifdef COPYLOCALFILES
	!include Registry.nsh
!endif
!include TextFunc.nsh
!include WordFunc.nsh
!include PortableApps.comInstallerDriveFreeSpaceCustom.nsh
!include PortableApps.comInstallerDumpLogToFile.nsh
!include PortableApps.comInstallerTBProgress.nsh

;=== Program Icon
Icon "PortableApps.comInstaller.ico"
!define MUI_ICON "PortableApps.comInstaller.ico"
!define MUI_UNICON "PortableApps.comInstaller.ico"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP "PortableApps.comInstallerHeader.bmp"
!define MUI_HEADERIMAGE_BITMAP_RTL "PortableApps.comInstallerHeaderRTL.bmp"
!define MUI_HEADERIMAGE_RIGHT

;=== Icon & Stye ===
BrandingText "${LEGAL}"

;=== Pages
!ifdef COPYLOCALFILES
	!define MUI_CUSTOMFUNCTION_ABORT CustomAbortFunction
!endif
!define MUI_LANGDLL_WINDOWTITLE "${PORTABLEAPPNAME}"
!define MUI_LANGDLL_INFO "Please select language:"
!define MUI_WELCOMEFINISHPAGE_BITMAP "PortableApps.comInstaller.bmp"
!define MUI_WELCOMEPAGE_TITLE "${PORTABLEAPPNAMEDOUBLEDAMPERSANDS}"
!define MUI_WELCOMEPAGE_TEXT "$(welcome)"
!define MUI_PAGE_CUSTOMFUNCTION_PRE PreWelcome
!define MUI_COMPONENTSPAGE_SMALLDESC
!insertmacro MUI_PAGE_WELCOME
!ifdef LICENSEAGREEMENT
	;!define MUI_LICENSEPAGE_CHECKBOX
	!define MUI_PAGE_CUSTOMFUNCTION_PRE PreLicense
	!define MUI_PAGE_CUSTOMFUNCTION_SHOW ShowLicense
	!define MUI_PAGE_CUSTOMFUNCTION_LEAVE LeaveLicense
	!insertmacro MUI_PAGE_LICENSE "..\..\App\AppInfo\${LICENSEAGREEMENT}"
!endif
!ifdef MAINSECTIONTITLE
;	!define MUI_PAGE_CUSTOMFUNCTION_PRE PreComponents
	!insertmacro MUI_PAGE_COMPONENTS
!endif
!define MUI_DIRECTORYPAGE_VERIFYONLEAVE
!define MUI_PAGE_CUSTOMFUNCTION_PRE PreDirectory
!define MUI_PAGE_CUSTOMFUNCTION_LEAVE LeaveDirectory
!insertmacro MUI_PAGE_DIRECTORY
!define MUI_PAGE_CUSTOMFUNCTION_SHOW ShowInstFiles
!insertmacro MUI_PAGE_INSTFILES
!define MUI_FINISHPAGE_TEXT "$(finish)"
!define MUI_PAGE_CUSTOMFUNCTION_PRE PreFinish
!define MUI_FINISHPAGE_TITLE_3LINES
;!define MUI_FINISHPAGE_CANCEL_ENABLED ;Disabled due to bug in MUI2
!ifndef DISABLE_FINISH_RUN
	!ifndef PLUGINNAME
		!ifndef UAC
			!define MUI_FINISHPAGE_RUN_NOTCHECKED
			!define MUI_FINISHPAGE_RUN "$INSTDIR\${FINISHPAGERUN}"
		!endif
	!endif
!endif
!insertmacro MUI_PAGE_FINISH
;=== Languages
!ifndef INSTALLERMULTILINGUAL
	!insertmacro MUI_LANGUAGE "${INSTALLERLANGUAGE}"
	!include PortableApps.comInstallerLanguages\${INSTALLERLANGUAGE}.nsh
!else
	!tempfile LangAutoDetectFile
	!macro IncludeLang _LANG_NAME
		; define and filename are all uppercase but both case insensitive
		!ifdef USES_${_LANG_NAME}
			!insertmacro MUI_LANGUAGE "${_LANG_NAME}"
			!include PortableApps.comInstallerLanguages\${_LANG_NAME}.nsh
			!appendfile "${LangAutoDetectFile}" "${Case} ${LANG_${_LANG_NAME}}$\n"
		!endif
	!macroend
	!define IncludeLang "!insertmacro IncludeLang"
	${IncludeLang} ENGLISH
	!insertmacro MUI_RESERVEFILE_LANGDLL
!endif

;=== Macros
LangString PLUGIN ${LANG_AZERBAIJANI} `$0 yüklü deyil!`
LangString PLUGIN ${LANG_BASQUE} `$0 instalatu gabe dago!`
LangString PLUGIN ${LANG_BOSNIAN} `$0 nije instaliran!`
LangString PLUGIN ${LANG_GALICIAN} `$0 non está instalado!`
LangString PLUGIN ${LANG_KAZAKH} `$0 орнатылған жоқ!`
LangString PLUGIN ${LANG_KURDISH} `$0 is not installed!`
LangString PLUGIN ${LANG_SERBIANLATIN} `$0 nije instaliran !`
LangString PLUGIN ${LANG_ENGLISH} "$0 is not installed!"
LangString PLUGIN ${LANG_ENGLISHAU} "$0 is not installed!"
LangString PLUGIN ${LANG_ENGLISHGB} "$0 is not installed!"
LangString PLUGIN ${LANG_AMHARIC} "$0 is not installed!"
LangString PLUGIN ${LANG_ARABIC} "لم يتم تثبيت $0!"
LangString PLUGIN ${LANG_BENGALI} "$0 ইনস্টল করা হয় না!"
LangString PLUGIN ${LANG_BULGARIAN} "$0 не е инсталиран!"
LangString PLUGIN ${LANG_CATALAN} "$0 no està instal·lat!"
LangString PLUGIN ${LANG_SIMPCHINESE} "$0未安装！"
LangString PLUGIN ${LANG_TRADCHINESE} "$0未安裝！"
LangString PLUGIN ${LANG_CROATIAN} "$0 nije instaliran!"
LangString PLUGIN ${LANG_CZECH} "$0 není nainstalován!"
LangString PLUGIN ${LANG_DANISH} "$0 er ikke installeret!"
LangString PLUGIN ${LANG_DUTCH} "$0 is niet geïnstalleerd!"
LangString PLUGIN ${LANG_ESTONIAN} "$0 ei ole paigaldatud!"
LangString PLUGIN ${LANG_FILIPINO} "$0 Hindi naka-install!"
LangString PLUGIN ${LANG_FINNISH} "$0 ei ole asennettu!"
LangString PLUGIN ${LANG_FRENCH} "$0 est pas installé!"
LangString PLUGIN ${LANG_FRENCHCA} "$0 est pas installé!"
LangString PLUGIN ${LANG_MOROCCAN} "$0 est pas installé!"
LangString PLUGIN ${LANG_GERMAN} "$0 ist nicht installiert!"
LangString PLUGIN ${LANG_GREEK} "$0 δεν είναι εγκατεστημένο!"
LangString PLUGIN ${LANG_GUJARATI} "$0 સ્થાપિત થયેલ નથી!"
LangString PLUGIN ${LANG_HEBREW} "$0 אינו מותקן!"
LangString PLUGIN ${LANG_HINDI} "$0 स्थापित नहीं है!"
LangString PLUGIN ${LANG_HUNGARIAN} "$0 nincs telepítve!"
LangString PLUGIN ${LANG_INDONESIAN} "$0 tidak diinstal!"
LangString PLUGIN ${LANG_ITALIAN} "$0 non è installato!"
LangString PLUGIN ${LANG_JAPANESE} "$0がインストールされていません！"
LangString PLUGIN ${LANG_KANNADA} "$0 ಅನುಸ್ಥಾಪಿತಗೊಂಡಿಲ್ಲ!"
LangString PLUGIN ${LANG_KOREAN} "$0가 설치되어 있지 않습니다!"
LangString PLUGIN ${LANG_LATVIAN} "$0 nav uzstādīts!"
LangString PLUGIN ${LANG_LITHUANIAN} "$0 neįdiegta!"
LangString PLUGIN ${LANG_MALAY} "$0 tidak dipasang!"
LangString PLUGIN ${LANG_MALAYALAM} "$0 ഇൻസ്റ്റാളുചെയ്തില്ല!"
LangString PLUGIN ${LANG_MARATHI} "$0 स्थापित नाही!"
LangString PLUGIN ${LANG_NORWEGIAN} "$0 er ikke installert!"
LangString PLUGIN ${LANG_FARSI} "$0 از نصب نشده است!"
LangString PLUGIN ${LANG_POLISH} "$0 nie jest zainstalowany!"
LangString PLUGIN ${LANG_PORTUGUESEBR} "$0 não está instalado!"
LangString PLUGIN ${LANG_PORTUGUESE} "$0 não está instalado!"
LangString PLUGIN ${LANG_ROMANIAN} "$0 nu este instalat!"
LangString PLUGIN ${LANG_RUSSIAN} "$0 не установлен!"
LangString PLUGIN ${LANG_SERBIAN} "ЈД није инсталиран!"
LangString PLUGIN ${LANG_SLOVAK} "$0 nie je nainštalovaný!"
LangString PLUGIN ${LANG_SLOVENIAN} "$0 ni nameščen!"
LangString PLUGIN ${LANG_SPANISH} "$0 no está instalado!"
LangString PLUGIN ${LANG_SPANISHINTERNATIONAL} "$0 no está instalado!"
LangString PLUGIN ${LANG_SWAHILI} "$0 si imewekwa!"
LangString PLUGIN ${LANG_SWEDISH} "$0 är inte installerat!"
LangString PLUGIN ${LANG_TAMIL} "$0 நிறுவப்பட்ட!"
LangString PLUGIN ${LANG_TELUGU} "$0 ఇన్స్టాల్ కాలేదు!"
LangString PLUGIN ${LANG_THAI} "$0 ไม่ได้ติดตั้ง!"
LangString PLUGIN ${LANG_TURKISH} "$0 yüklü değil!"
LangString PLUGIN ${LANG_UKRAINIAN} "$0 не встановлено!"
LangString PLUGIN ${LANG_VIETNAMESE} "$0 chưa được cài đặt!"
!macro _ReDef _NAME _VAL
	!ifdef ${_NAME}
		!undef ${_NAME}
	!endif
	!define ${_NAME} `${_VAL}`
!macroend
!define ReDef "!insertmacro _ReDef "
Function GetAfterChar
	!macro _GetAfterChar _STR _CHAR _RET
		Push `${_STR}`
		Push `${_CHAR}`
		Call GetAfterChar
		Pop `${_RET}`
	!macroend
	!define GetAfterChar "!insertmacro _GetAfterChar"
	Exch $0
	Exch
	Exch $1
	Push $2
	Push $3
	StrCpy $2 0
	IntOp $2 $2 - 1
	StrCpy $3 $1 1 $2
	StrCmp $3 "" 0 +3
	StrCpy $0 ""
	Goto +5
	StrCmp $3 $0 +2
	Goto -6
	IntOp $2 $2 + 1
	StrCpy $0 $1 "" $2
	Pop $3
	Pop $2
	Pop $1
	Exch $0
FunctionEnd
Function RelGotoPage
	IntCmp $R9 0 0 Move Move
	StrCmp $R9 "X" 0 Move
	StrCpy $R9 "120"
	Move:
	SendMessage $HWNDPARENT "0x408" "$R9" ""
FunctionEnd
!define CABW         CabinetWClass
Function Close
	!macro _Close _CLASS _TITLE
		Push `${_TITLE}`
		Push `${_CLASS}`
		Call Close
	!macroend
	!define Close `!insertmacro _Close`
	Exch $R2
	Exch
	Exch $R1
	Push $R0
	Search:
		FindWindow $R0 `$R2` `$R1`
		IntCmp $R0 0 END 0 0
		IsWindow $R0 0 END
		System::Call `user32::PostMessage(i,i,i,i) i($R0,0x0010,0,0)`
		Sleep 100
		Goto Search
	END:
	Pop $R0
	Pop $R1
	Pop $R2
FunctionEnd
!ifdef CheckHasDotNetFramework
Function HasDotNETFramework
	!macro _HasDotNETFramework _a _b _t _f
		!insertmacro _LOGICLIB_TEMP
		Call HasDotNETFramework
		Pop $_LOGICLIB_TEMP
		!insertmacro _= $_LOGICLIB_TEMP 1 `${_t}` `${_f}`
	!macroend
	!define HasDotNETFramework `"" HasDotNETFramework ""`
	!define NET `SOFTWARE\Microsoft\.NETFramework`
	!define POL `SOFTWARE\Microsoft\.NETFramework\policy`
	Push $0
	Push $1
	Push $2
	Push $3
	Push $4
	ReadRegStr $4 HKLM `${NET}` InstallRoot
	Push $4
	Exch $EXEDIR
	Exch $EXEDIR
	Pop $4
	IfFileExists $4 0 +10
	StrCpy $0 0
	EnumRegKey $2 HKLM `${POL}` $0
	IntOp $0 $0 + 1
	StrCmp $2 "" +6
	StrCpy $1 0
	EnumRegValue $3 HKLM `${POL}\$2` $1
	IntOp $1 $1 + 1
	StrCmp $3 "" -6
	IfFileExists `$4\$2.$3` +3 -3
	StrCpy $0 0
	Goto +2
	StrCpy $0 1
	Pop $4
	Pop $3
	Pop $2
	Pop $1
	Exch $0
FunctionEnd
!endif
!ifdef Include_ProcFunc.nsh
	Function CloseX
		!macro _CloseX _PROCESS
			Push `${_PROCESS}`
			Call CloseX
		!macroend
		!define CloseX "!insertmacro _CloseX"
		Exch $0
		Push $1
		Close:
		${If} ${ProcessExists} `$0`
			${CloseProcess} `$0` $1
			${If} ${ProcessExists} `$0`
				${TerminateProcess} `$0` $1
				Sleep 1000
				Goto Close
			${EndIf}
		${EndIf}
		Pop $1
		Pop $0
	FunctionEnd
!endif
!ifdef XML_PLUGIN
!define XMLWriteText "!insertmacro _XMLWriteText"
!macro _XMLWriteText _FILE _XPATH _VALUE
	nsisXML::create
	nsisXML::load `${_FILE}`
	nsisXML::select `${_XPATH}`
	StrCmpS $2 0 0 +3
	SetErrors
	Goto +4
	nsisXML::setText `${_VALUE}`
	nsisXML::release $1
	nsisXML::save `${_FILE}`
	nsisXML::release $0
!macroend
!define XMLReadText "!insertmacro _XMLReadText"
!macro _XMLReadText _FILE _XPATH _RETURN
	nsisXML::create
	nsisXML::load `${_FILE}`
	nsisXML::select `${_XPATH}`
	StrCmpS $2 0 0 +4
	StrCpy `${_RETURN}` error
	SetErrors
	Goto +6
	nsisXML::GetText
	StrCpy `${_RETURN}` $3
	nsisXML::release $1
	nsisXML::save `${_FILE}`
	nsisXML::release $0
!macroend
!define XMLWriteAttrib "!insertmacro _XMLWriteAttrib"
!macro _XMLWriteAttrib _FILE _XPATH _ATTRIBUTE _VALUE
	nsisXML::create
	nsisXML::load `${_FILE}`
	nsisXML::select `${_XPATH}`
	StrCmpS $2 0 0 +3
	SetErrors
	Goto +5
	nsisXML::setAttribute `${_ATTRIBUTE}` `${_VALUE}`
	nsisXML::release $1
	nsisXML::save `${_FILE}`
	nsisXML::release $0
!macroend
!define XMLReadAttrib "!insertmacro _XMLReadAttrib"
!macro _XMLReadAttrib _FILE _XPATH _ATTRIBUTE _RETURN
	nsisXML::create
	nsisXML::load `${_FILE}`
	nsisXML::select `${_XPATH}`
	StrCmpS $2 0 0 +4
	StrCpy `${_RETURN}` error
	SetErrors
	Goto +6
	nsisXML::getAttribute `${_ATTRIBUTE}`
	StrCpy `${_RETURN}` $3
	nsisXML::release $1
	nsisXML::save `${_FILE}`
	nsisXML::release $0
!macroend
!endif
Function Trim
	!macro _Trim _RESULT _STRING
		Push `${_STRING}`
		Call Trim
		Pop `${_RESULT}`
	!macroend
	!define Trim `!insertmacro _Trim`
	Exch $R1
	Push $R2
	StrCpy $R2 `$R1` 1
	StrCmpS `$R2` " " +5
	StrCmpS `$R2` `$\r` +4
	StrCmpS `$R2` `$\n` +3
	StrCmpS `$R2` `$\t` +2
	GoTo +3
	StrCpy $R1 `$R1` "" 1
	Goto -7
	StrCpy $R2 `$R1` 1 -1
	StrCmpS `$R2` " " +5
	StrCmpS `$R2` `$\r` +4
	StrCmpS `$R2` `$\n` +3
	StrCmpS `$R2` `$\t` +2
	GoTo +3
	StrCpy $R1 `$R1` -1
	Goto -7
	Pop $R2
	Exch $R1
FunctionEnd
!macro !insertmacro1-10 _m
!insertmacro ${_m} 1
!insertmacro ${_m} 2
!insertmacro ${_m} 3
!insertmacro ${_m} 4
!insertmacro ${_m} 5
!insertmacro ${_m} 6
!insertmacro ${_m} 7
!insertmacro ${_m} 8
!insertmacro ${_m} 9
!insertmacro ${_m} 10
!macroend
!define !insertmacro1-10 "!insertmacro !insertmacro1-10"
;=== Variables
Var FOUNDPORTABLEAPPSPATH
;!ifdef MAINSECTIONTITLE
;	Var OPTIONAL1DONE
;!endif
Var AUTOMATEDINSTALL
Var AUTOCLOSE
Var SILENTLANGUAGEMODE
Var HIDEINSTALLER
Var MINIMIZEINSTALLER
!ifdef LICENSEAGREEMENT
	Var EULAVERSIONMATCH
!endif
!ifdef COPYLOCALFILES
	Var CopyLocalFilesFrom
	Var CopyLocalFilesTo
	Var MISSINGFILEORPATH
!endif
!ifdef DOWNLOADURL
	Var MD5MISMATCH
	Var DOWNLOADRESULT
	Var DOWNLOADEDFILE
	Var DOWNLOADALREADYEXISTED
	Var SECONDDOWNLOADATTEMPT
	Var DownloadURLActual
!endif
Var INTERNALEULAVERSION
Var InstallingStatusString
Var bolAppUpgrade
Var bolLogFile
Var PAcLocaleID
Var strLastDirectory
Var strTimeStore
;=== Custom Code
!ifdef USESCUSTOMCODE
	!if ${__FILE__} == "PortableApps.comInstallerPlugin.nsi"
		!include PortableApps.comInstallerPluginCustom.nsh
	!else
		!include PortableApps.comInstallerCustom.nsh
	!endif
!endif
!ifdef INSTALLERMULTILINGUAL
	!macro CaseLang _LANG_NAME _LANG_ID
		!ifdef USES_${_LANG_NAME}
			${Case} ${_LANG_ID}
		!endif
	!macroend
	!define CaseLang "!insertmacro CaseLang"
!endif
!ifdef Registry
	!include Registry.nsh
!endif

Function .onInit
	InitPluginsDir
	!ifdef UAC
		Elevate:
		!insertmacro UAC_RunElevated
		${Switch} $0
			${Case} 0
				StrCmpS $1 1 0 +3
				Call .onInstFailed
				Quit
				${If} $3 <> 0
					${Break}
				${EndIf}
				StrCmpS $1 3 0 +4
				MessageBox MB_RETRYCANCEL|MB_ICONEXCLAMATION|MB_TOPMOST \ 
				"${APPNAME} requires administrative privileges to run.$\r$\n$\r$\nPress Retry to try authenticating again or Cancel to quit." \ 
				IDRETRY Elevate
				Call .onInstFailed
				Quit
			${Case} 1223
				MessageBox MB_ICONEXCLAMATION|MB_TOPMOST \ 
				"${APPNAME} requires administrative privileges to run."
				Call .onInstFailed
				Quit
			${Case} 1062
				MessageBox MB_ICONEXCLAMATION|MB_TOPMOST \ 
				"${APPNAME} requires administrative privileges, but the Windows Logon service is not running. ${APPNAME} can not start."
				Call .onInstFailed
				Quit
			${Case} ""
				MessageBox MB_ICONEXCLAMATION|MB_TOPMOST \ 
				"Unable to run as administrator, error $0.$\r$\n${APPNAME} requires administrative privileges to run."
				Call .onInstFailed
				Quit
		${EndSwitch}
		${GetParameters} $0
		ClearErrors
		${GetOptions} $0 /UAC $1
		${IfNot} ${Errors}
			${WordReplace} $0 /UAC$1 "" + $0
			${Trim} $0 $0
		${EndIf}
		ClearErrors
		${GetOptions} $0 /NCRC $1
		${IfNot} ${Errors}
			${WordReplace} $0 /NCRC$1 "" + $0
			${Trim} $0 $0
		${EndIf}
	!endif
	!ifdef ExtractionOnly
		!ifndef UAC
			${GetParameters} $0
		!endif
		ClearErrors
		${GetOptions} $0 -x $1
		IfErrors +2
		StrCpy $CMD 1
		ClearErrors
		${GetOptions} $0 /x $1
		IfErrors +2
		StrCpy $CMD 1
	!endif
	!ifndef CUSTOMSIZE
		!ifdef OPTIONALSECTION1SIZE
			SectionSetSize 1 ${OPTIONALSECTION1SIZE}
		!endif
		!ifdef OPTIONALSECTION2SIZE
			SectionSetSize 2 ${OPTIONALSECTION2SIZE}
		!endif
		!ifdef OPTIONALSECTION3SIZE
			SectionSetSize 3 ${OPTIONALSECTION3SIZE}
		!endif
		!ifdef OPTIONALSECTION4SIZE
			SectionSetSize 4 ${OPTIONALSECTION4SIZE}
		!endif
		!ifdef OPTIONALSECTION5SIZE
			SectionSetSize 5 ${OPTIONALSECTION5SIZE}
		!endif
		!ifdef OPTIONALSECTION6SIZE
			SectionSetSize 6 ${OPTIONALSECTION6SIZE}
		!endif
	!endif
	!ifdef FORCEONLYONESELECTION
		Push $0
		StrCpy $1 ${OPTIONALSECTION1}
		SectionGetFlags ${OPTIONALSECTION1} $0
		IntOp $0 $0 | ${SECTION_ON}
		SectionSetFlags ${OPTIONALSECTION1} $0
		SectionGetFlags ${OPTIONALSECTION2} $0
		IntOp $0 $0 & ${SECTION_OFF}
		SectionSetFlags ${OPTIONALSECTION2} $0
		SectionGetFlags ${OPTIONALSECTION3} $0
		IntOp $0 $0 & ${SECTION_OFF}
		SectionSetFlags ${OPTIONALSECTION3} $0
		SectionGetFlags ${OPTIONALSECTION4} $0
		IntOp $0 $0 & ${SECTION_OFF}
		SectionSetFlags ${OPTIONALSECTION4} $0
		Pop $0
	!endif
	SetSilent normal
	!ifdef DownloadURL
	StrCpy $R0 $EXEFILE "" -15
	${If} $R0 != "_online.paf.exe"
	${AndIf} $R0 != "line.paf[1].exe" ;Handle IE's renaming of files when run directly from a download
	${AndIf} $R0 != "line.paf[2].exe"
	${AndIf} $R0 != "line.paf[3].exe"
	${AndIf} $R0 != "line.paf[4].exe"
	${AndIf} $R0 != "line.paf[5].exe"
	${AndIf} $R0 != "line.paf[6].exe"
	${AndIf} $R0 != "line.paf[7].exe"
	${AndIf} $R0 != "line.paf[8].exe"
	${AndIf} $R0 != "line.paf[9].exe"
		MessageBox MB_OK|MB_ICONSTOP `PortableApps.com Installers that download files must end with "_online.paf.exe".  This is to ensure that users always know that an installer downloads files before it is run.  Please rename the file to end in _online.paf.exe before running.`
		Abort
	${EndIf}
	!endif
	!ifdef INSTALLERMULTILINGUAL
		ReadEnvStr $PAcLocaleID "PortableApps.comLocaleID"
		${Switch} $PAcLocaleID
			!include "${LangAutoDetectFile}"
			!delfile "${LangAutoDetectFile}"
			!undef LangAutoDetectFile
				StrCpy $LANGUAGE $PAcLocaleID
				${Break}
			${Default}
				${GetOptions} $CMDLINE "/DESTINATION=" $0
				${IfNot} ${Errors}
				${AndIf} ${FileExists} `$0\PortableApps.com\PortableAppsPlatform.exe`
					${If} $PAcLocaleID == 3082 ;SpanishInternational
					${AndIf} ${USES_SPANISH} == "true"
						StrCpy $LANGUAGE 1034 ;Spanish
					${Else}
						${If} $PAcLocaleID == 1034 ;Spanish
						${AndIf} ${USES_SPANISHINTERNATIONAL} == "true"
							StrCpy $LANGUAGE 3082 ;SpanishInternational
						${Else}
							${If} $PAcLocaleID == 1046 ;PortugueseBR
							${AndIf} ${USES_PORTUGUESE} == "true"
								StrCpy $LANGUAGE 2070 ;Portuguese
							${Else}
								${If} $PAcLocaleID == 2070 ;Portuguese
								${AndIf} ${USES_PORTUGUESEBR} == "true"
									StrCpy $LANGUAGE 1046 ;PortugueseBR
								${Else}
									StrCpy $LANGUAGE 1033 ;English as last fallback
								${EndIf}
							${EndIf}
						${EndIf}
					${EndIf}
				${Else}
					!insertmacro MUI_LANGDLL_DISPLAY
				${EndIf}
		${EndSwitch}
	!endif
	${GetOptions} $CMDLINE "/LOG=" $0
	${IfNot} ${Errors}
	${AndIf} $0 == "true"
		StrCpy $bolLogFile true
	${Else}
		ClearErrors
	${EndIf}
	${GetOptions} $CMDLINE "/DESTINATION=" $0
	${IfNot} ${Errors}
		!ifdef COMMONFILESPLUGIN
			StrCpy $INSTDIR "$0CommonFiles\${APPID}"
		!else
			${GetOptions} $CMDLINE "/COPYNUMBER=" $1
			${IfNot} ${Errors}
				StrCpy $INSTDIR "$0${APPID}_Copy_$1"
			${Else}
				StrCpy $INSTDIR "$0${APPID}"
			${EndIf}
		!endif
		${GetParent} $INSTDIR $0
		!ifdef COMMONFILESPLUGIN
			${GetParent} $0 $0
		!endif
		DetailPrint '$(checkforplatform)'
		${If} ${FileExists} `$0\PortableApps.com\PortableAppsPlatform.exe`
			MoreInfo::GetProductName `$0\PortableApps.com\PortableAppsPlatform.exe`
			Pop $1
			${If} $1 == "PortableApps.com Platform"
				MoreInfo::GetCompanyName `$0\PortableApps.com\PortableAppsPlatform.exe`
				Pop $1
				${If} $1 == "PortableApps.com"
					FindProcDLL::FindProc "PortableAppsPlatform.exe"
					${If} $R0 == 1
						StrCpy $AUTOMATEDINSTALL "true"
						ClearErrors
						${GetOptions} $CMDLINE "/AUTOCLOSE=" $R0
						${IfNot} ${Errors}
						${AndIf} $R0 == "true"
							StrCpy $AUTOCLOSE "true"
						${EndIf}
						ClearErrors
						${GetOptions} $CMDLINE "/HIDEINSTALLER=" $R0
						${IfNot} ${Errors}
						${AndIf} $R0 == "true"
							StrCpy $HIDEINSTALLER "true"
						${EndIf}
						ClearErrors
						${GetOptions} $CMDLINE "/MINIMIZEINSTALLER=" $R0
						${IfNot} ${Errors}
						${AndIf} $R0 == "true"
							StrCpy $MINIMIZEINSTALLER "true"
						${EndIf}
						ClearErrors
						${GetOptions} $CMDLINE "/SILENT=" $R0
						${IfNot} ${Errors}
						${AndIf} $R0 == "true"
							SectionGetSize ${MAINSECTIONIDX} $1 ;=== Space Required for App
							!ifdef MAINSECTIONTITLE
								SectionGetFlags ${OPTIONALSECTIONIDX} $9
								IntOp $9 $9 & ${SF_SELECTED}
								${If} $9 >= ${SF_SELECTED}
									SectionGetSize ${OPTIONALSECTIONIDX} $2 ;=== Space Required for App
									IntOp $1 $1 + $2
								${EndIf}
							!endif
							${GetRoot} $INSTDIR $2
							;${DriveSpace} `$2\` "/D=F /S=M" $3 ;=== Space Free on Device
							${DriveFreeSpaceCustom} "$2\" $3
							IntOp $1 $1 / 1024
							${If} $1 == 0
								StrCpy $1 1
							${EndIf}
							${If} $3 <= $1
								IntOp $1 $1 * 1024
								IntOp $3 $3 * 1024
								!ifndef PLUGININSTALLER ;=== If not a plugin installer, add the current install size to free space
									${If} ${FileExists} $INSTDIR
										${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=0" $4 $5 $6 ;=== Current installation size
										IntOp $3 $3 + $4 ;=== Space Free + Current Root Install Size
										${GetSize} `$INSTDIR\App` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
										IntOp $3 $3 + $4 ;=== Space Free + Current App Install Size
										${GetSize} `$INSTDIR\Other` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
										IntOp $3 $3 + $4 ;=== Space Free + Current Other Install Size
										${If} `${ADDONSDIRECTORYPRESERVE}` != "NONE"
										${AndIf} ${FileExists} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}`
												${GetSize} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Size of Data directory
												IntOp $3 $3 - $4 ;=== Remove the plugins directory from the free space calculation
										${EndIf}
									${EndIf}
								!else
									!ifdef COMMONFILESPLUGIN ;Duplicate code for now, to do above for CommonFiles as well
										${If} ${FileExists} $INSTDIR
											${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
											IntOp $3 $3 + $4 ;=== Space Free + Current Install Size
										${EndIf}
									!endif
								!endif
								${If} $3 <= $1
									MessageBox MB_OK|MB_ICONEXCLAMATION "$(notenoughspace)"
									Abort
								${EndIf}
							${EndIf}
							!ifdef LICENSEAGREEMENT
								${If} $EULAVERSIONMATCH == "true"
									SetSilent silent
								${EndIf}
							!else
								SetSilent silent
							!endif
						${EndIf}
						ClearErrors
						${GetOptions} $CMDLINE "/SILENTLANGUAGEMODE=" $R0
						${IfNot} ${Errors}
							${If} $R0 == "auto"
							${OrIf} $R0 == "never"
							${OrIf} $R0 == "always"
								StrCpy $SILENTLANGUAGEMODE $R0
							${Else}
								StrCpy $SILENTLANGUAGEMODE "auto"
							${EndIf}
						${Else}
							StrCpy $SILENTLANGUAGEMODE "auto"
						${EndIf}

					${EndIf}
				${EndIf}
			${EndIf}
		${EndIf}
	${Else}
		ClearErrors
		${GetOptions} $CMDLINE "-o" $R0
		${IfNot} ${Errors}
			!ifdef COMMONFILESPLUGIN
				!ifdef NON-SPECIFIC-PLUGIN
					StrCpy $INSTDIR "$R0CommonFiles"
				!else
					StrCpy $INSTDIR "$R0CommonFiles\${APPID}"
				!endif
			!else
				!ifdef NON-SPECIFIC-PLUGIN
					StrCpy $INSTDIR ""
				!else
					StrCpy $INSTDIR "$R0${APPID}"
				!endif
			!endif
		${Else}
			ClearErrors
			${If} ${FileExists}	"$PROFILE\PortableApps\*.*"
				StrCpy $FOUNDPORTABLEAPPSPATH "$Profile\PortableApps"
			${Else}
				${GetDrives} "HDD+FDD" GetDrivesCallBack
			${EndIf}
			${If} $FOUNDPORTABLEAPPSPATH != ""
				!ifdef COMMONFILESPLUGIN
					!ifdef NON-SPECIFIC-PLUGIN
						StrCpy $INSTDIR "$FOUNDPORTABLEAPPSPATH\CommonFiles"
					!else
						StrCpy $INSTDIR "$FOUNDPORTABLEAPPSPATH\CommonFiles\${APPID}"
					!endif
				!else
					!ifdef NON-SPECIFIC-PLUGIN
						StrCpy $INSTDIR ""
					!else
						StrCpy $INSTDIR "$FOUNDPORTABLEAPPSPATH\${APPID}"
					!endif
				!endif
			${Else}
				${WordFind} "$EXEDIR\" "$PROGRAMFILES\" "*" $R0
				${WordFind} "$EXEDIR\" "$PROGRAMFILES64\" "*" $R1
				${WordFind} "$EXEDIR\" "$INTERNET_CACHE\" "*" $R2
				${WordFind} "$EXEDIR\" "$TEMP\" "*" $R3
				${If} $R0 > 0
				${OrIf} $R1 > 0
				${OrIf} $R2 > 0
				${OrIf} $R3 > 0
					StrCpy $INSTDIR ""
				${Else}
					!ifdef COMMONFILESPLUGIN
						!ifdef NON-SPECIFIC-PLUGIN
							StrCpy $INSTDIR "$EXEDIR\CommonFiles"
						!else
							StrCpy $INSTDIR "$EXEDIR\CommonFiles\${APPID}"
						!endif
					!else
						!ifdef NON-SPECIFIC-PLUGIN
							StrCpy $INSTDIR ""
						!else
							StrCpy $INSTDIR "$EXEDIR\${APPID}"
						!endif
					!endif
				${EndIf}
			${EndIf}
		${EndIf}
	${EndIf}
	!ifdef AdditionalInstallSize
		SectionGetSize ${MAINSECTIONIDX} $0
		IntOp $0 $0 + ${AdditionalInstallSize}
		SectionSetSize ${MAINSECTIONIDX} $0
	!endif
	!ifdef DEFAULTSIZE
		SectionSetSize ${MAINSECTIONIDX} `${DEFAULTSIZE}`
	!endif
	${If} "${CHECKRUNNING}" != "NONE"
		RunningTryAgain:
		FindProcDLL::FindProc "${CHECKRUNNING}"
		${If} $R0 == 1
			MessageBox MB_OKCANCEL|MB_ICONINFORMATION $(runwarning) IDOK RunningTryAgain IDCANCEL RunningCancel
			RunningCancel:
				Abort
		${EndIf}
	${EndIf}
FunctionEnd
Function PreWelcome
	${IfThen} $AUTOMATEDINSTALL == "true" ${|} Abort ${|}
FunctionEnd
!ifdef LICENSEAGREEMENT
Function PreLicense
	${If} $AUTOMATEDINSTALL == "true"
	${AndIf} $EULAVERSIONMATCH == "true"
		Abort
	${EndIf}

	!ifndef EULAVERSION
		StrCpy $INTERNALEULAVERSION "1"
	!else
		StrCpy $INTERNALEULAVERSION "${EULAVERSION}"
	!endif
	${If} ${FileExists} "$INSTDIR\Data\PortableApps.comInstaller\license.ini"
		ReadINIStr $0 "$INSTDIR\Data\PortableApps.comInstaller\license.ini" "PortableApps.comInstaller" "EULAVersion"
		ClearErrors
		${If} $0 == $INTERNALEULAVERSION
		${AndIf} $AUTOMATEDINSTALL == "true"
			Abort
		${EndIf}
	${EndIf}
FunctionEnd
Function ShowLicense
	${If} $AUTOMATEDINSTALL == "true"
		${TBProgress} 20
		${TBProgress_State} Paused
	${EndIf}
FunctionEnd
Function LeaveLicense
	${If} $AUTOMATEDINSTALL == "true"
		${TBProgress_State} NoProgress
	${EndIf}
FunctionEnd
!endif
Function ShowInstFiles
!ifdef Check64
	${IfNot} ${RunningX64}
		MessageBox MB_OKCANCEL|MB_ICONINFORMATION|MB_TOPMOST `$(64)` IDOK +3 IDCANCEL 0
		Call .onInstFailed
		Quit
	${EndIf}
!endif
!ifdef CheckNET
	!if ${CheckNET} == ""
		${IfNot} ${HasDotNETFramework}
			StrCpy $0 `Microsoft .NET Framework`
			MessageBox MB_YESNO|MB_ICONQUESTION|MB_TOPMOST `$(MINREQ)` IDYES +3 IDNO 0
			Call .onInstFailed
			Quit
		${EndIf}
	!else if ${CheckNET} == 4.5
		${IfNot} ${HasDotNet4.0}
			ClearErrors
			EnumRegKey $0 HKLM `${NDP}\v4\Full` 0
			IfErrors +5
			StrCmpS $0 "" +4
			ReadRegDWORD $0 HKLM `${NDP}\$0` Version
			StrCpy $0 $0 3
			StrCmpS $0 4.5 +4
			MessageBox MB_YESNO|MB_ICONQUESTION|MB_TOPMOST `${PORTABLEAPPNAME} requires Microsoft .NET Framework 4.5 or newer, continue anyway?` IDYES +3 IDNO 0
			Call .onInstFailed
			Quit
		${EndIf}
	!else
		${IfNot} ${HasDotNet${CheckNET}}
			StrCpy $0 `Microsoft .NET Framework ${CheckNET}`
			MessageBox MB_YESNO|MB_ICONQUESTION|MB_TOPMOST `$(MINREQ)` IDYES +3 IDNO 0
			Call .onInstFailed
			Quit
		${EndIf}
	!endif
!endif
!ifdef FORCE_SELECTION
	SectionGetFlags ${OPTIONALSECTION1} $0
	SectionGetFlags ${OPTIONALSECTION2} $1
	IntOp $0 $0 & ${SF_SELECTED}
	IntOp $1 $1 & ${SF_SELECTED}
	${If} $0 != ${SF_SELECTED}
	${AndIf} $1 != ${SF_SELECTED}
		MESSAGEBOX MB_ICONSTOP|MB_TOPMOST `$(SELECTION)`
		StrCpy $R9 -2
		Call RelGotoPage
		Abort
	${EndIf}
!endif
!ifndef PLUGININSTALLER
	${If} ${IsNT}
		${IfNot} ${IsWin10}
			StrCpy $0 `Windows 10`
			MessageBox MB_YESNO|MB_ICONQUESTION|MB_TOPMOST `$(MINREQ)` IDYES +3 IDNO 0
			Call .onInstFailed
			Quit
		${EndIf}
	${Else}
		StrCpy $0 `Windows 10`
		MessageBox MB_YESNO|MB_ICONQUESTION|MB_TOPMOST `$(MINREQ)` IDYES +3 IDNO 0
		Call .onInstFailed
		Quit
	${EndIf}
	${If} ${FileExists} `$INSTDIR\${APPNAME}.exe`
		MoreInfo::GetCompanyName `$INSTDIR\${APPNAME}.exe`
		Pop $0
		${Select} $0 
			${Case} `${BRANDING}`
			${CaseElse}
				MESSAGEBOX MB_OKCANCEL|MB_ICONINFORMATION|MB_TOPMOST `$(DEVELOPER)` IDOK +3 IDCANCEL 0
				Call .onInstFailed
				Quit
		${EndSelect}
	${EndIf}
!else ifdef PLUGIN
	IfFileExists `$INSTDIR\${APPID}.exe` +5
	StrCpy $0 `${CLOSENAME}`
	MESSAGEBOX MB_ICONSTOP|MB_TOPMOST `$(PLUGIN)`
	Call .onInstFailed
	Quit
!endif
w7tbp::Start
FunctionEnd
Function PreDirectory
	${IfThen} $AUTOMATEDINSTALL != "true" ${|} Return ${|}
	SectionGetSize ${MAINSECTIONIDX} $1 ;=== Space Required for App
	!ifdef MAINSECTIONTITLE
		SectionGetFlags ${OPTIONALSECTIONIDX} $9
		IntOp $9 $9 & ${SF_SELECTED}
		${If} $9 >= ${SF_SELECTED}
			SectionGetSize ${OPTIONALSECTIONIDX} $2 ;=== Space Required for App
			IntOp $1 $1 + $2
		${EndIf}
	!endif
	${GetRoot} $INSTDIR $2
	;${DriveSpace} `$2\` "/D=F /S=M" $3 ;=== Space Free on Device
	${DriveFreeSpaceCustom} "$2\" $3
	IntOp $1 $1 / 1024
	${If} $3 <= $1
		IntOp $1 $1 * 1024
		IntOp $3 $3 * 1024
		!ifndef PLUGININSTALLER ;=== If not a plugin installer, add the current install size to free space
			${If} ${FileExists} $INSTDIR
				${GetSize} $INSTDIR "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
				IntOp $3 $3 + $4 ;=== Space Free + Current Install Size
				${If} ${FileExists} `$INSTDIR\Data`
					${GetSize} `$INSTDIR\Data` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Size of Data directory
					IntOp $3 $3 - $4 ;=== Remove the data directory from the free space calculation
				${EndIf}
				${If} `${ADDONSDIRECTORYPRESERVE}` != "NONE"
				${AndIf} ${FileExists} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}`
						${GetSize} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Size of Data directory
						IntOp $3 $3 - $4 ;=== Remove the plugins directory from the free space calculation
				${EndIf}
			${EndIf}
		!else
			!ifdef COMMONFILESPLUGIN ;Duplicate code for now, to do above for CommonFiles as well
				${If} ${FileExists} $INSTDIR
					${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
					IntOp $3 $3 + $4 ;=== Space Free + Current Install Size
				${EndIf}
			!endif
		!endif
		${If} $3 <= $1
			MessageBox MB_OK|MB_ICONEXCLAMATION "$(notenoughspace)"
			Return
		${EndIf}
	${EndIf}
	${IfThen} "${CHECKRUNNING}" == "NONE" ${|} Abort ${|}
	FindProcDLL::FindProc "${CHECKRUNNING}"
	${IfThen} $R0 != "1" ${|} Abort ${|}
	MessageBox MB_OK|MB_ICONINFORMATION $(runwarning)
FunctionEnd
Function LeaveDirectory
	;=== Prevent destination string changes without user verification
	${GetTime} "" "LS" $0 $1 $2 $3 $4 $5 $6
	${If} $strTimeStore == "$0 $1 $2 $3 $4 $5 $6"
		${GetParent} $INSTDIR $0
		${GetParent} $0 $0
		StrCpy $1 $0 3 -6
		StrCpy $2 $0 1 -2
		${If} $2 == "e"
		${AndIf} $1 == "ber"
			Abort
		${EndIf}
	${EndIf}
	GetInstDirError $0
	${If} ${FileExists} $INSTDIR
	${AndIf} "${CHECKRUNNING}" != NONE
		!ifdef NON-SPECIFIC-PLUGIN
			!ifndef COMMONFILESPLUGIN
				!ifdef BrowserPlugin
					${GetAfterChar} `$INSTDIR` \ `$0`
					${If} $0 == ChromePortable
						${ReDef} APPID $0
						CHROME:
						${If} ${ProcessExists} chrome.exe
						${AndIf} ${ProcessExists} ChromePortable.exe
							MessageBox MB_OKCANCEL|MB_ICONSTOP|MB_TOPMOST `$(CLOSE)` IDOK CHROME IDCANCEL 0
							Abort
						${EndIf}
					${ElseIf} $0 == ChromiumPortable
						${ReDef} APPID $0
						CHROMIUM:
						${If} ${ProcessExists} chrome.exe
						${AndIf} ${ProcessExists} ChromiumPortable.exe
							MessageBox MB_OKCANCEL|MB_ICONSTOP|MB_TOPMOST `$(CLOSE)` IDOK CHROMIUM IDCANCEL 0
							Abort
						${EndIf}
					${ElseIf} $0 == IronPortable
						${ReDef} APPID $0
						IRON:
						${If} ${ProcessExists} chrome.exe
						${AndIf} ${ProcessExists} IronPortable.exe
							MessageBox MB_OKCANCEL|MB_ICONSTOP|MB_TOPMOST `$(CLOSE)` IDOK IRON IDCANCEL 0
							Abort
						${EndIf}
					${EndIf}
				!else
					FindProcDLL::FindProc "${CHECKRUNNING}"
					${If} $R0 = 1
						MessageBox MB_OK|MB_ICONINFORMATION $(runwarning)
						Abort
					${EndIf}
				!endif
			!endif
		!else
			FindProcDLL::FindProc "${CHECKRUNNING}"
			${If} $R0 = 1
				MessageBox MB_OK|MB_ICONINFORMATION $(runwarning)
				Abort
			${EndIf}
		!endif
	${EndIf}
	${Select} $0
		${Case} 1
			MessageBox MB_OK|MB_ICONINFORMATION $(invaliddirectory)
			Abort
		${Case} 2
			${IfNot} ${FileExists} $INSTDIR ;=== Is upgrade
				MessageBox MB_OK|MB_ICONEXCLAMATION $(notenoughspace)
				Abort
			${EndIf}
			SectionGetSize ${MAINSECTIONIDX} $1 ;=== Space Required for App
			!ifdef MAINSECTIONTITLE
					SectionGetFlags ${OPTIONALSECTIONIDX} $9
					IntOp $9 $9 & ${SF_SELECTED}
					${If} $9 >= ${SF_SELECTED}
						SectionGetSize ${OPTIONALSECTIONIDX} $2 ;=== Space Required for App
						IntOp $1 $1 + $2
					${EndIf}
			!endif
			${GetRoot} $INSTDIR $2
			;${DriveSpace} `$2\` "/D=F /S=K" $3 ;=== Space Free on Device
			${DriveFreeSpaceCustom} "$2\" $3
			!ifndef PLUGININSTALLER ;=== If not a plugin installer, add the current install size to free space
				${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=0" $4 $5 $6 ;=== Current installation size
				IntOp $3 $3 + $4 ;=== Space Free + Current Root Install Size
				${GetSize} `$INSTDIR\App` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
				IntOp $3 $3 + $4 ;=== Space Free + Current App Install Size
				${GetSize} `$INSTDIR\Other` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
				IntOp $3 $3 + $4 ;=== Space Free + Current Other Install Size
				${If} `${ADDONSDIRECTORYPRESERVE}` != "NONE"
				${AndIf} ${FileExists} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}`
						${GetSize} `$INSTDIR\${ADDONSDIRECTORYPRESERVE}` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Size of Data directory
						IntOp $3 $3 - $4 ;=== Remove the plugins directory from the free space calculation
				${EndIf}
			!else
				!ifdef COMMONFILESPLUGIN ;Duplicate code for now, to do above for CommonFiles as well
					${GetSize} `$INSTDIR` "/M=*.* /S=0K /G=1" $4 $5 $6 ;=== Current installation size
					IntOp $3 $3 + $4 ;=== Space Free + Current Install Size
				!endif
			!endif
			${If} $3 <= $1
				MessageBox MB_OK|MB_ICONEXCLAMATION "$(notenoughspace)"
				Abort
			${EndIf}
	${EndSelect}
	ReadEnvStr $0 IPromiseNotToComplainWhenPortableAppsDontWorkRightInProgramFiles
	${If} $0 != "I understand that this may not work and that I can not ask for help with any of my apps when operating in this fashion."
		${WordFind} "$INSTDIR\" "$PROGRAMFILES\" "*" $R0
		${If} $R0 > 0
			MessageBox MB_OK|MB_ICONINFORMATION "$(invaliddirectory) [$PROGRAMFILES or sub-directories]"
			Abort
		${EndIf}
		${WordFind} "$INSTDIR\" "$PROGRAMFILES64\" "*" $R0
		${If} $R0 > 0
			MessageBox MB_OK|MB_ICONINFORMATION "$(invaliddirectory) [$PROGRAMFILES64 or sub-directories]"
			Abort
		${EndIf}
	${EndIf}
FunctionEnd
Function .onVerifyInstDir
	${If} $INSTDIR != ""
	${AndIf} $strLastDirectory != ""
		StrLen $0 $INSTDIR
		StrLen $1 $strLastDirectory
		IntOp $2 $1 + 2
		IntOp $3 $1 - 2
		${If} $0 > $2
		${OrIf} $0 < $3
			${GetTime} "" "LS" $0 $1 $2 $3 $4 $5 $6
			StrCpy $strTimeStore "$0 $1 $2 $3 $4 $5 $6"
		${EndIf}	
	${EndIf}
	StrCpy $strLastDirectory $INSTDIR
FunctionEnd
!ifndef SC_CLOSE
!define SC_CLOSE 0xF060
!endif
Function PreFinish
	${IfThen} $AUTOCLOSE == "true" ${|} Abort ${|}
	EnableWindow $mui.Button.Cancel 1
	System::Call 'USER32::GetSystemMenu(i $hwndparent,i0)i.s'
	System::Call 'USER32::EnableMenuItem(is,i${SC_CLOSE},i0)'
FunctionEnd
Function GetDrivesCallBack
	${If} $8 == "FDD"
		${If} $9 == "A:\"
		${OrIf} $9 == "B:\"
			Push $0
			Return
		${EndIf}
	${EndIf}
	${If} ${FileExists} $9PortableApps
		StrCpy $FOUNDPORTABLEAPPSPATH $9PortableApps
	${EndIf}
	Push $0
FunctionEnd

!ifdef SHOWMAINSECTIONTITLE
	Section "${MAINSECTIONTITLE}"
!else
	Section "-${MAINSECTIONTITLE}"
!endif
	${If} $MINIMIZEINSTALLER == "true"
		ShowWindow $HWNDPARENT ${SW_MINIMIZE}
	${EndIf}
	${If} $HIDEINSTALLER == "true"
		ShowWindow $HWNDPARENT ${SW_HIDE}
	${EndIf}
	${If} ${FileExists} "$INSTDIR\*.*"
		StrCpy $bolAppUpgrade true
	${EndIf}
	${If} $(installingstatus) != ""
		StrCpy $InstallingStatusString "$(installingstatus)"
	${Else}
		StrCpy $InstallingStatusString "$(MUI_TEXT_INSTALLING_TITLE)"
	${EndIf}
	SectionIn RO
	SetOutPath $INSTDIR
	${If} $bolAppUpgrade == true
		${If} $(prepareupgrade) == ""
			DetailPrint $InstallingStatusString
		${Else}
			DetailPrint $(prepareupgrade)
		${EndIf}
	${Else}
		DetailPrint $InstallingStatusString
	${EndIf}
	SetDetailsPrint ListOnly
!ifdef MAINSECTIONTITLE
	SectionGetFlags 1 $0
	IntOp $0 $0 & ${SF_SELECTED}
	${If} $0 != ${SF_SELECTED}
		;=== BEGIN: OPTIONAL NOT SELECTED CLEANUP CODE ===
		;This will be executed before install if the optional section (additional languages, etc) is not selected
		!ifmacrodef CustomCodeOptionalCleanup
			!insertmacro CustomCodeOptionalCleanup
		!endif
		;=== END: OPTIONAL NOT SELECTED CLEANUP CODE ===
	${EndIf}
!endif
################################################################################
# PRE INSTALL                                                                  #
################################################################################
!ifndef PLUGININSTALLER
	${If} ${FileExists} `$INSTDIR\${APPNAME}.exe`
		MoreInfo::GetCompanyName `$INSTDIR\${APPNAME}.exe`
		Pop $0
		${Select} $0 
			${Case} `${BRANDING}`
			${CaseElse}
				RMDIR /r `${DATA}`
				Delete `$INSTDIR\*.*`
		${EndSelect}
		!ifdef CompareFileVersion
			MoreInfo::GetFileVersion `$INSTDIR\${APPNAME}.exe`
			Pop $0
			${VersionCompare} $0 ${BUILD} $1
			${Select} $1
				${Case} 0
				${CaseElse}
			${EndSelect}
		!endif
	${EndIf}
	${If} ${FileExists} `$INSTDIR\${APPNAME}.ini`
		${ConfigRead} `$INSTDIR\${APPNAME}.ini` AdditionalParameters= $ADDITIONALPARAMETERS
		${ConfigRead} `$INSTDIR\${APPNAME}.ini` RunLocally= $RUNLOCALLY
		${ConfigRead} `$INSTDIR\${APPNAME}.ini` Banner= $Banner
	${EndIf}
	Delete `$INSTDIR\*.*`
!endif

	IfFileExists `${REG}` 0 +2
	WriteINIStr `${REG}` `HKEY_CURRENT_USER\SOFTWARE\Yamicsoft\Windows 10 Manager` `"Version"` `"${VER}"`

RMDir /r `${DATA}\PortableApps.comInstaller`
!ifndef PLUGININSTALLER
	RMDir `${DATA}\My Documents`
	IfFileExists `${SET}\${APPNAME}Settings.ini` 0 +4
	DeleteINIStr `${SET}\${APPNAME}Settings.ini` ${APPNAME}Settings Architecture
	DeleteINIStr `${SET}\${APPNAME}Settings.ini` ${APPNAME}Settings Signature
	DeleteINIStr `${SET}\${APPNAME}Settings.ini` ${APPNAME}Settings LastSystemDrive
!endif

!ifndef PLUGININSTALLER
!ifndef DISABLE_BACKUP
	${If} $CMD != 1
		StrCpy $R9 1
		${Do}
			ClearErrors
			ReadINIStr $R8 `${INS}` FilesToPreserve PreserveFile$R9
			${IfThen} ${Errors} ${|} ${ExitDo} ${|}
			WriteINIStr `${INI}` FilesToPreserve PreserveFile$R9 `$R8`
			${If} ${FileExists} `$INSTDIR\$R8`
				${GetFileName} `$R8` `$R7`
				Rename `$INSTDIR\$R8` `~$R9$R7`
			${EndIf}
			IntOp $R9 $R9 + 1
		${Loop}
		StrCpy $R9 1
		${Do}
			ClearErrors
			ReadINIStr $R8 `${INS}` DirectoriesToPreserve PreserveDirectory$R9
			${IfThen} ${Errors} ${|} ${ExitDo} ${|}
			WriteINIStr `${INI}` DirectoriesToPreserve PreserveDirectory$R9 `$R8`
			${If} ${FileExists} `$INSTDIR\$R8`
				${GetAfterChar} `$R8` `\` `$R7`
				Rename `$INSTDIR\$R8` `$INSTDIR\~$R9$R7`
			${EndIf}
			IntOp $R9 $R9 + 1
		${Loop}
	${EndIf}
!endif
!endif

!ifdef OPTIONALSECTION1
	SectionGetFlags ${OPTIONALSECTION1} $0
	IntOp $0 $0 & ${SF_SELECTED}
	${If} $0 >= ${SF_SELECTED}
		StrCpy $SECTION1 1
	${EndIf}
!endif
!ifdef OPTIONALSECTION2
	SectionGetFlags ${OPTIONALSECTION2} $0
	IntOp $0 $0 & ${SF_SELECTED}
	${If} $0 >= ${SF_SELECTED}
		StrCpy $SECTION2 1
	${EndIf}
!endif
!ifdef OPTIONALSECTION3
	SectionGetFlags ${OPTIONALSECTION3} $0
	IntOp $0 $0 & ${SF_SELECTED}
	${If} $0 >= ${SF_SELECTED}
		StrCpy $SECTION3 1
	${EndIf}
!endif
!ifdef OPTIONALSECTION4
	SectionGetFlags ${OPTIONALSECTION4} $0
	IntOp $0 $0 & ${SF_SELECTED}
	${If} $0 >= ${SF_SELECTED}
		StrCpy $SECTION4 1
	${EndIf}
!endif
!ifdef OPTIONALSECTION5
	SectionGetFlags ${OPTIONALSECTION5} $0
	IntOp $0 $0 & ${SF_SELECTED}
	${If} $0 >= ${SF_SELECTED}
		StrCpy $SECTION5 1
	${EndIf}
!endif
!ifdef OPTIONALSECTION6
	SectionGetFlags ${OPTIONALSECTION6} $0
	IntOp $0 $0 & ${SF_SELECTED}
	${If} $0 >= ${SF_SELECTED}
		StrCpy $SECTION6 1
	${EndIf}
!endif

!ifdef Registry
	;=== Crash Recovery
	ClearErrors
	ReadRegStr $0 HKCU `SOFTWARE\${APPNAME}` Running
	IfErrors +2
	Call RestoreRegistry
	;=== Backup
	WriteRegStr HKCU `SOFTWARE\${APPNAME}` Running 1
	Call BackupRegistry
!endif

!ifdef DOWNLOADURL
	ClearErrors
	RMDir /r `${APPINFO}`
	${If} ${Errors}
		${Close} `${CABW}` ""
		RMDir /r `${APPINFO}`
	${EndIf}
	ClearErrors
	RMDir /r `${DEFDATA}`
	${If} ${Errors}
		${Close} `${CABW}` ""
		RMDir /r `${DEFDATA}`
	${EndIf}
	ClearErrors
	Delete `$INSTDIR\App\Readme.txt`
	${If} ${Errors}
		${Close} `${CABW}` ""
		Delete `$INSTDIR\App\Readme.txt`
	${EndIf}
	ClearErrors
	RMDir /r `${OTHER}`
	${If} ${Errors}
		${Close} `${CABW}` ""
		RMDir /r `${OTHER}`
	${EndIf}
!else
	!ifdef NON-SPECIFIC-PLUGIN
		!ifdef COMMONFILESPLUGIN
			${If} $Section1 = 1
				ClearErrors
				RMDir /r `$INSTDIR\Java`
				${If} ${Errors}
					${Close} `${CABW}` ""
					RMDir /r `$INSTDIR\Java`
				${EndIf}
			${EndIf}
			${If} $Section2 = 1
				ClearErrors
				RMDir /r `$INSTDIR\Java64`
				${If} ${Errors}
					${Close} `${CABW}` ""
					RMDir /r `$INSTDIR\Java64`
				${EndIf}
			${EndIf}
		!else
			!if ${APP} == PepperFlash
				!define PLG   `${DATA}\${APP}`
				!define PLG64 `${DATA}\${APP64}`
				!define INSTALLER !PEPPERPLUGININSTALLER
				ClearErrors
				RMDir /r `${PLG}`
				${If} ${Errors}
					${Close} `${CABW}` ""
					RMDir /r `${PLG}`
				${EndIf}
				ClearErrors
				RMDir /r `${PLG64}`
				${If} ${Errors}
					${Close} `${CABW}` ""
					RMDir /r `${PLG64}`
				${EndIf}
			!else if ${APP} == AdobeFlash
				!define PLG   `${DATA}\Plugins`
				!define PLG64 `${DATA}\Plugins64`
				!define INSTALLER !AdobeFlashPLUGININSTALLER
				ClearErrors
				DELETE `${PLG}\manifest.json`
				DELETE `${PLG}\mms.cfg`
				DELETE `${PLG}\NP*.dll`
				RMDIR `${PLG}`
				${If} ${Errors}
					${Close} `${CABW}` ""
					DELETE `${PLG}\manifest.json`
					DELETE `${PLG}\mms.cfg`
					DELETE `${PLG}\NP*.dll`
					RMDIR `${PLG}`
				${EndIf}
				ClearErrors
				DELETE `${PLG64}\manifest.json`
				DELETE `${PLG64}\mms.cfg`
				DELETE `${PLG64}\NP*.dll`
				RMDIR /r `${PLG64}`
				${If} ${Errors}
					${Close} `${CABW}` ""
					DELETE `${PLG64}\manifest.json`
					DELETE `${PLG64}\mms.cfg`
					DELETE `${PLG64}\NP*.dll`
					RMDIR `${PLG64}`
				${EndIf}
			!endif
		!endif
	!else ifdef COMMONFILESPLUGIN
		;=== Commonfiles plugin but non non-specific.
	!else ifdef PLUGININSTALLER
		${If} $Section1 = 1
			ClearErrors
			RMDir /r `${APPDIR}\jre`
			${If} ${Errors}
				${Close} `${CABW}` ""
				RMDir /r `${APPDIR}\jre`
			${EndIf}
		${EndIf}
		${If} $Section2 = 1
			ClearErrors
			RMDir /r `${APPDIR64}\jre`
			${If} ${Errors}
				${Close} `${CABW}` ""
				RMDir /r `${APPDIR64}\jre`
			${EndIf}
		${EndIf}
	!else
		ClearErrors
		RMDir /r `$INSTDIR\App`
		${If} ${Errors}
			${Close} `${CABW}` ""
			RMDir /r `$INSTDIR\App`
		${EndIf}
		ClearErrors
		RMDir /r `${OTHER}`
		${If} ${Errors}
			${Close} `${CABW}` ""
			RMDir /r `${OTHER}`
		${EndIf}
	!endif
!endif

${If} $bolAppUpgrade == true
	SetDetailsPrint both
	DetailPrint $InstallingStatusString
	SetDetailsPrint ListOnly
${EndIf}

!ifndef PLUGININSTALLER
	SetOutPath `$INSTDIR`
	File /x thumbs.db `..\..\*.exe`
	SetOutPath `$INSTDIR\App`
	File /r /x thumbs.db `..\..\App\*.*`
!else ifdef COMMONFILESPLUGIN
	StrCmp $Section1 1 0 +3
	SetOutPath `$INSTDIR\${APP}`
	File /r /x thumbs.db `..\..\App\${APP}\*.*`
	StrCmp $Section2 1 0 +3
	SetOutPath `$INSTDIR\${APP64}`
	File /r /x thumbs.db `..\..\App\${APP64}\*.*`
	SetOutPath `${APPINFO}`
	File /x thumbs.db `..\..\App\AppInfo\plugininstaller.ini`
	StrCmp $CMD 1 0 +3
	SetOutPath `${APPINFO}\Launcher\Source\!JREPLUGiNiNSTALLER`
	File /x thumbs.db `..\..\App\AppInfo\Launcher\Source\!JREPLUGiNiNSTALLER\*.*`
!else ; non-CommonFiles plugin installer
	StrCmp $CMD 1 0 +3
	SetOutPath `${APPINFO}\Launcher\Source\!PLUGiNiNSTALLER`
	File /x thumbs.db `..\..\App\AppInfo\Launcher\Source\!PLUGiNiNSTALLER\*.*`
	SetOutPath `${APPINFO}`
	File /x thumbs.db `..\..\App\AppInfo\plugininstaller.ini`
!endif

!ifdef DownloadURL
	StrCmp $CMD 1 OFFLINE
	${If} $Section1 = 1
		${If} ${FileExists} `$EXEDIR\${DownloadFileName}`
			StrCpy $DOWNLOADEDFILE `$EXEDIR\${DownloadFileName}`
		${Else}
			StrCpy $DownloadURLActual ${DownloadURL}
			StrCpy $DOWNLOADEDFILE `$PLUGINSDIR\${DownloadFileName}`
			DOWNLOAD:
			SetDetailsPrint both
			DetailPrint `$(DOWNLOADING)`
			SetDetailsPrint none
			Delete "$DOWNLOADEDFILE"
			inetc::get /CONNECTTIMEOUT 30 /NOCOOKIES /TRANSLATE `$(DOWNLOADING)` $(downloadconnecting) $(downloadsecond) $(downloadminute) $(downloadhour) $(downloadplural) `%dkB (%d%%) of %dkB @ %d.%01dkB/s` ` (%d %s%s $(downloadremaining))` `$DownloadURLActual` `$DOWNLOADEDFILE` /END
			SetDetailsPrint both
			DetailPrint $InstallingStatusString
			SetDetailsPrint ListOnly
			Pop $DOWNLOADRESULT
			${If} $DOWNLOADRESULT != OK
				${If} $SECONDDOWNLOADATTEMPT != true
				${AndIf} $DOWNLOADRESULT != Cancelled
					StrCpy $SECONDDOWNLOADATTEMPT true
					Goto DOWNLOAD
				${ElseIf} $SECONDDOWNLOADATTEMPT == true
				${AndIf} $DOWNLOADRESULT != Cancelled
					SetDetailsPrint both
					DetailPrint `$(DOWNLOADING)`
					SetDetailsPrint none
					File '/oname=$PLUGINSDIR\wget.exe' `${NSISDIR}\..\7zip\wget.exe`
					StrCpy $2 ""
					Backup:
					Delete `$DOWNLOADEDFILE`
					SetOutPath `$PLUGINSDIR`
					ExecDos::Exec /TOSTACK `"$PLUGINSDIR\wget.exe" --referer="https://www.google.com" --user-agent="Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6" -T 2 --no-check-certificate "$DownloadURLActual" --output-document=${DownloadFileName}`
					Pop $0
					Pop $1
					${If} $0 = 1
						${If} $2 = 1
							SetDetailsPrint textonly
							DetailPrint ""
							SetDetailsPrint listonly
							${TBProgress_State} Error
							MessageBox MB_ICONEXCLAMATION|MB_TOPMOST $(downloadfailed)
							DetailPrint $(downloadfailed)
							${TBProgress_State} NoProgress
							Goto Section2
						${Else}
							StrCpy $2 1
							Goto Backup
						${EndIf}
					${EndIf}
				${EndIf}
			${EndIf}
		${EndIf}
		SetDetailsPrint none
		${If} $DOWNLOADRESULT != Cancelled
		${AndIf} ${FileExists} `$DOWNLOADEDFILE`
			ClearErrors
			RMDir /r `${APPDIR}`
			${If} ${Errors}
				${Close} `${CABW}` ""
				RMDir /r `${APPDIR}`
			${EndIf}
			ClearErrors
			${GetFileVersion} `${APPDIR}\${APP}.exe` $0
			IfErrors +2
			WriteINIStr `${APPINFO}\appinfo.ini` Version PackageVersion $0
		${Else}
			SetDetailsPrint textonly
			DetailPrint ""
			SetDetailsPrint listonly
			${TBProgress_State} Error
			MessageBox MB_ICONEXCLAMATION|MB_TOPMOST $(downloadfailed)
			DetailPrint $(downloadfailed)
			${TBProgress_State} NoProgress
		${EndIf}
	${Else}
		ClearErrors
		RMDir /r `${APPDIR}`
		${If} ${Errors}
			${Close} `${CABW}` ""
			RMDir /r `${APPDIR}`
		${EndIf}
	${EndIf}
	Section2:
	${If} $Section2 = 1
		${ConfigRead} `${INS}` DownloadURL64= $URL2
		${ConfigRead} `${INS}` DownloadFilename64= $File2
		${If} ${FileExists} `$EXEDIR\$File2`
			StrCpy $DOWNLOADEDFILE `$EXEDIR\$File2`
		${Else}
			StrCpy $SECONDDOWNLOADATTEMPT ""
			StrCpy $DownloadURLActual $URL2
			StrCpy $DOWNLOADEDFILE `$PLUGINSDIR\$File2`
			DOWNLOAD64:
			SetDetailsPrint both
			DetailPrint `$(DOWNLOADING)`
			SetDetailsPrint none
			Delete "$DOWNLOADEDFILE"
			inetc::get /CONNECTTIMEOUT 30 /NOCOOKIES /TRANSLATE `$(DOWNLOADING)` $(downloadconnecting) $(downloadsecond) $(downloadminute) $(downloadhour) $(downloadplural) `%dkB (%d%%) of %dkB @ %d.%01dkB/s` ` (%d %s%s $(downloadremaining))` `$DownloadURLActual` `$DOWNLOADEDFILE` /END
			SetDetailsPrint both
			DetailPrint $InstallingStatusString
			SetDetailsPrint ListOnly
			Pop $DOWNLOADRESULT
			${If} $DOWNLOADRESULT != OK
				${If} $SECONDDOWNLOADATTEMPT != true
				${AndIf} $DOWNLOADRESULT != Cancelled
					StrCpy $SECONDDOWNLOADATTEMPT true
					Goto DOWNLOAD64
				${ElseIf} $SECONDDOWNLOADATTEMPT == true
				${AndIf} $DOWNLOADRESULT != Cancelled
					SetDetailsPrint both
					DetailPrint `$(DOWNLOADING)`
					SetDetailsPrint none
					File '/oname=$PLUGINSDIR\wget.exe' `${NSISDIR}\..\7zip\wget.exe`
					StrCpy $2 ""
					Backup64:
					Delete `$DOWNLOADEDFILE`
					SetOutPath `$PLUGINSDIR`
					ExecDos::Exec /TOSTACK `"$PLUGINSDIR\wget.exe" --referer="https://www.google.com" --user-agent="Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6" -T 2 --no-check-certificate "$DownloadURLActual" --output-document=$File2`
					Pop $0
					Pop $1
					${If} $0 = 1
						${If} $2 = 1
							SetDetailsPrint textonly
							DetailPrint ""
							SetDetailsPrint listonly
							${TBProgress_State} Error
							MessageBox MB_ICONEXCLAMATION|MB_TOPMOST $(downloadfailed)
							DetailPrint $(downloadfailed)
							${TBProgress_State} NoProgress
							Goto OFFLINE
						${Else}
							StrCpy $2 1
							Goto Backup64
						${EndIf}
					${EndIf}
				${EndIf}
			${EndIf}
		${EndIf}
		SetDetailsPrint none
		${If} $DOWNLOADRESULT != Cancelled
		${AndIf} ${FileExists} `$DOWNLOADEDFILE`
			ClearErrors
			RMDir /r `${APPDIR64}`
			${If} ${Errors}
				${Close} `${CABW}` ""
				RMDir /r `${APPDIR64}`
			${EndIf}
			ClearErrors
			${GetFileVersion} `${APPDIR64}\${APP}.exe` $0
			IfErrors +2
			WriteINIStr `${APPINFO}\appinfo.ini` Version PackageVersion $0
		${Else}
			SetDetailsPrint textonly
			DetailPrint ""
			SetDetailsPrint listonly
			${TBProgress_State} Error
			MessageBox MB_ICONEXCLAMATION|MB_TOPMOST $(downloadfailed)
			DetailPrint $(downloadfailed)
			${TBProgress_State} NoProgress
		${EndIf}
	${Else}
		ClearErrors
		RMDir /r `${APPDIR64}`
		${If} ${Errors}
			${Close} `${CABW}` ""
			RMDir /r `${APPDIR64}`
		${EndIf}
	${EndIf}
	OFFLINE:
	StrCmp $CMD 1 0 +5
	StrCmp $SECTION1 1 0 +2
	CreateDirectory `${APPDIR}`
	StrCmp $SECTION2 1 0 +2
	CreateDirectory `${APPDIR64}`
!endif
################################################################################
# POST INSTALL                                                                 #
################################################################################
!ifndef PLUGININSTALLER
	SetOutPath `${OTHER}`
	File /x thumbs.db "..\..\Other\*.*"
	SetOutPath `$INSTDIR`
	File /x thumbs.db `..\..\Other\${APPNAME}.ini`
	${If} $ADDITIONALPARAMETERS != ""
		${ConfigWrite} `$INSTDIR\${APPNAME}.ini` AdditionalParameters= $ADDITIONALPARAMETERS $R0
	${EndIf}
	${If} $RUNLOCALLY != ""
		${ConfigWrite} `$INSTDIR\${APPNAME}.ini` RunLocally= $RUNLOCALLY $R0
	${EndIf}
	${If} $BANNER != ""
		${ConfigWrite} `$INSTDIR\${APPNAME}.ini` Banner= $BANNER $R0
	${EndIf}
!endif

!ifndef PLUGININSTALLER
!ifndef DISABLE_BACKUP
	${If} $CMD != 1
	${AndIf} $SKIP != true
		StrCpy $R9 1
		${Do}
			ClearErrors
			ReadINIStr $R8 `${INI}` FilesToPreserve PreserveFile$R9
			${IfThen} ${Errors} ${|} ${ExitDo} ${|}
			WriteINIStr `${INS}` FilesToPreserve PreserveFile$R9 $R8 ;=== preserve user's settings.
			${GetFileName} `$R8` `$R7`
			${If} ${FileExists} `$INSTDIR\~$R9$R7`
				Delete `$INSTDIR\$R8`
				Rename `$INSTDIR\~$R9$R7` `$INSTDIR\$R8`
			${EndIf}
			IntOp $R9 $R9 + 1
		${Loop}
		StrCpy $R9 1
		${Do}
			ClearErrors
			ReadINIStr $R8 `${INI}` DirectoriesToPreserve PreserveDirectory$R9
			${IfThen} ${Errors} ${|} ${ExitDo} ${|}
			WriteINIStr `${INS}` DirectoriesToPreserve PreserveDirectory$R9 $R8 ;=== preserve user's settings.
			${GetAfterChar} `$R8` `\` `$R7`
			${If} ${FileExists} `$INSTDIR\~$R9$R7`
				RMDir /r `$INSTDIR\$R8`
				Rename `$INSTDIR\~$R9$R7` `$INSTDIR\$R8`
			${EndIf}
			IntOp $R9 $R9 + 1
		${Loop}
		FindFirst $R0 $R1 `$INSTDIR\*`
			${DoWhile} $R1 != ""
			${If} $R1 != "."
			${AndIf} $R1 != ".."
				StrCpy $R2 $R1 1
				StrCmp $R2 ~ 0 +3
				Delete `$INSTDIR\$R1`
				RMDir /r `$INSTDIR\$R1`
			${EndIf}
			FindNext $R0 $R1
			${Loop}
		FindClose $R0
		Delete `${INI}`
	${EndIf}
!endif
!endif

!ifndef PLUGININSTALLER
${GetParent} $INSTDIR $0
SetDetailsPrint both
DetailPrint '$(checkforplatform)'
${If} ${FileExists} `$0\PortableApps.com\PortableAppsPlatform.exe`
	MoreInfo::GetProductName `$0\PortableApps.com\PortableAppsPlatform.exe`
	Pop $1
	${If} $1 == "PortableApps.com Platform"
		MoreInfo::GetCompanyName `$0\PortableApps.com\PortableAppsPlatform.exe`
		Pop $1
		${If} $1 == PortableApps.com
			FindProcDLL::FindProc PortableAppsPlatform.exe
			${If} $R0 = 1
				CreateDirectory "$0\PortableApps.com\Data"
				WriteINIStr "$0\PortableApps.com\Data\NewApp.ini" NewApp AppID `${APPID}`
				DetailPrint '$(refreshmenu)'
				IfFileExists `$0\PortableApps.com\App\PortableAppsPlatform.exe` +5
					StrCpy $2 'PortableApps.comPlatformWindowMessageToRefresh$0\PortableApps.com\PortableAppsPlatform.exe'
					System::Call "user32::RegisterWindowMessage(t r2) i .r3"
					SendMessage 65535 $3 0 0 /TIMEOUT=1
				Goto +4
					StrCpy $2 'PortableApps.comPlatformWindowMessageToRefresh$0\PortableApps.com\App\PortableAppsPlatform.exe'
					System::Call "user32::RegisterWindowMessage(t r2) i .r3"
					SendMessage 65535 $3 0 0 /TIMEOUT=1
			${EndIf}
		${EndIf}
	${EndIf}
${EndIf}
!endif
	DetailPrint $InstallingStatusString
	SetDetailsPrint listonly
	Delete "$INSTDIR\7zTemp\7z.exe"
	Delete "$INSTDIR\7zTemp\7z.dll"
	RMDir "$INSTDIR\7zTemp"
!ifdef Registry
	Call RestoreRegistry
	DeleteRegKey HKCU `SOFTWARE\${APPNAME}`
	Registry::_Unload
!endif
!ifdef DownloadURL
	Delete "$INTERNET_CACHE\$FILE2"
	Delete "$INTERNET_CACHE\${FILE1}"
	Delete "$INTERNET_CACHE\${FILE2}"
	Delete "$INTERNET_CACHE\${DownloadFileName}"
!endif
	${If} $bolLogFile == true
		${DumpLogToFile} "$EXEDIR\$EXEFILE.log"
	${EndIf}
	SetOutPath $TEMP
	DeleteINISec "${APPINFO}\appinfo.ini" Installer
SectionEnd

!ifdef MAINSECTIONTITLE
	!ifdef OPTIONALSECTION1TITLE
		Section /o "!${OPTIONALSECTION1TITLE}" "${OPTIONALSECTION1}"
		SectionEnd
	!endif
	!ifdef OPTIONALSECTION2TITLE
		Section /o "!${OPTIONALSECTION2TITLE}" "${OPTIONALSECTION2}"
		SectionEnd
	!endif
	!ifdef OPTIONALSECTION3TITLE
		Section /o "${OPTIONALSECTION3TITLE}" "${OPTIONALSECTION3}"
		SectionEnd
	!endif
	!ifdef OPTIONALSECTION4TITLE
		Section /o "!${OPTIONALSECTION4TITLE}" "${OPTIONALSECTION4}"
		SectionEnd
	!endif
	!ifdef OPTIONALSECTION5TITLE
		Section /o "${OPTIONALSECTION5TITLE}" "${OPTIONALSECTION5}"
		SectionEnd
	!endif
	!ifdef OPTIONALSECTION6TITLE
		Section /o "${OPTIONALSECTION6TITLE}" "${OPTIONALSECTION6}"
		SectionEnd
	!endif
	!ifdef NON-SPECIFIC-PLUGIN
		!ifndef COMMONFILESPLUGIN
			!ifdef BrowserPlugin
				LangString 1 ${LANG_ENGLISH} "compatible with 32-bit Web Browsers"
				LangString 1 ${LANG_ENGLISHAU} "compatible with 32-bit Web Browsers"
				LangString 1 ${LANG_ENGLISHGB} "compatible with 32-bit Web Browsers"
				LangString 1 ${LANG_AMHARIC} "compatible with 32-bit Web Browsers"
				LangString 1 ${LANG_ARABIC} "متوافق مع متصفحات الويب 32 بت"
				LangString 1 ${LANG_BENGALI} "32-বিট ওয়েব ব্রাউজার সঙ্গে সামঞ্জস্যপূর্ণ"
				LangString 1 ${LANG_BULGARIAN} "съвместима с 32-битови уеб браузъри"
				LangString 1 ${LANG_CATALAN} "compatible amb els navegadors web de 32 bits"
				LangString 1 ${LANG_SIMPCHINESE} "与32位Web浏览器兼容"
				LangString 1 ${LANG_TRADCHINESE} "與32位Web瀏覽器兼容"
				LangString 1 ${LANG_CROATIAN} "kompatibilan s 32-bitnim web preglednicima"
				LangString 1 ${LANG_CZECH} "kompatibilní s 32-bitovými webové prohlížeče"
				LangString 1 ${LANG_DANISH} "kompatibel med 32-bit webbrowsere"
				LangString 1 ${LANG_DUTCH} "compatibel met 32-bits webbrowsers"
				LangString 1 ${LANG_ESTONIAN} "kooskõlas 32-bitine veebibrauserite"
				LangString 1 ${LANG_FILIPINO} "makibagay sa 32-bit Web Browser"
				LangString 1 ${LANG_FINNISH} "yhteensopiva 32-bittinen selaimet"
				LangString 1 ${LANG_FRENCH} "compatible avec 32 bits Navigateurs Web"
				LangString 1 ${LANG_GERMAN} "mit 32-Bit-Web-Browser kompatibel"
				LangString 1 ${LANG_GREEK} "συμβατό με 32-bit Προγράμματα περιήγησης στο Web"
				LangString 1 ${LANG_GUJARATI} "32-bit વેબ બ્રાઉઝર્સની સાથે સુસંગત"
				LangString 1 ${LANG_HEBREW} "תואם עם דפדפני אינטרנט 32 סיביות"
				LangString 1 ${LANG_HINDI} "32-बिट वेब ब्राउज़रों के साथ संगत"
				LangString 1 ${LANG_HUNGARIAN} "kompatibilis a 32 bites webböngészők"
				LangString 1 ${LANG_INDONESIAN} "kompatibel dengan 32-bit Web Browser"
				LangString 1 ${LANG_ITALIAN} "compatibile con i browser Web a 32 bit"
				LangString 1 ${LANG_JAPANESE} "32ビットのWebブラウザとの互換性"
				LangString 1 ${LANG_KANNADA} "32-ಬಿಟ್ ವೆಬ್ ಬ್ರೌಸರ್"
				LangString 1 ${LANG_KOREAN} "32 비트 웹 브라우저와 호환"
				LangString 1 ${LANG_LATVIAN} "saderīga ar 32-bitu Web pārlūkprogrammas"
				LangString 1 ${LANG_LITHUANIAN} "suderinama su 32 bitų interneto naršyklių"
				LangString 1 ${LANG_MALAY} "serasi dengan 32-bit Pelayar Web"
				LangString 1 ${LANG_MALAYALAM} "32-ബിറ്റ് വെബ് ബ്രൗസറുകളും പൊരുത്തപ്പെടുന്നു"
				LangString 1 ${LANG_MARATHI} "32-बिट वेब ब्राउझर सुसंगत"
				LangString 1 ${LANG_NORWEGIAN} "kompatibel med 32-bits nettlesere"
				LangString 1 ${LANG_FARSI} "سازگار با مرورگرهای وب 32 بیتی"
				LangString 1 ${LANG_POLISH} "kompatybilny z 32-bitowych przeglądarek internetowych"
				LangString 1 ${LANG_PORTUGUESEBR} "compatível com os navegadores Web de 32 bits"
				LangString 1 ${LANG_PORTUGUESE} "compatível com os navegadores Web de 32 bits"
				LangString 1 ${LANG_ROMANIAN} "compatibil cu 32 de biți browsere web"
				LangString 1 ${LANG_RUSSIAN} "совместима с 32-разрядными Web-браузеров"
				LangString 1 ${LANG_SERBIAN} "компатибилан са 32-битним Веб претраживачи"
				LangString 1 ${LANG_SLOVAK} "kompatibilný s 32-bitovými webové prehliadače"
				LangString 1 ${LANG_SLOVENIAN} "združljiv z 32-bitnimi Spletni brskalniki"
				LangString 1 ${LANG_SPANISH} "compatible con los navegadores web de 32 bits"
				LangString 1 ${LANG_SPANISHINTERNATIONAL} "compatible con los navegadores web de 32 bits"
				LangString 1 ${LANG_SWAHILI} "sambamba na 32-bit Browsers Mtandao"
				LangString 1 ${LANG_SWEDISH} "kompatibel med 32-bitars Webbläsare"
				LangString 1 ${LANG_TAMIL} "32-பிட் இணைய உலாவிகளில் இணக்கமானது"
				LangString 1 ${LANG_TELUGU} "32-బిట్ వెబ్ బ్రౌజర్లు అనుకూలంగా"
				LangString 1 ${LANG_THAI} "เข้ากันได้กับเว็บเบราเซอร์ 32 บิต"
				LangString 1 ${LANG_TURKISH} "32-bit Web Tarayıcıları ile uyumlu"
				LangString 1 ${LANG_UKRAINIAN} "сумісна з 32-розрядними Web-браузерів"
				LangString 1 ${LANG_VIETNAMESE} "tương thích với 32-bit Trình duyệt Web"
				LangString 2 ${LANG_ENGLISH} "compatible with 64-bit Web Browsers"
				LangString 2 ${LANG_ENGLISHAU} "compatible with 64-bit Web Browsers"
				LangString 2 ${LANG_ENGLISHGB} "compatible with 64-bit Web Browsers"
				LangString 2 ${LANG_AMHARIC} "compatible with 64-bit Web Browsers"
				LangString 2 ${LANG_ARABIC} "متوافق مع متصفحات الويب 64 بت"
				LangString 2 ${LANG_BENGALI} "64-বিট ওয়েব ব্রাউজার সঙ্গে সামঞ্জস্যপূর্ণ"
				LangString 2 ${LANG_BULGARIAN} "съвместима с 64-битови уеб браузъри"
				LangString 2 ${LANG_CATALAN} "compatible amb els navegadors web de 64 bits"
				LangString 2 ${LANG_SIMPCHINESE} "64位Web浏览器兼容"
				LangString 2 ${LANG_TRADCHINESE} "64位Web瀏覽器兼容"
				LangString 2 ${LANG_CROATIAN} "kompatibilan s 64-bitnim web preglednicima"
				LangString 2 ${LANG_CZECH} "kompatibilní s 64-bitovými webové prohlížeče"
				LangString 2 ${LANG_DANISH} "kompatibel med 64-bit webbrowsere"
				LangString 2 ${LANG_DUTCH} "compatibel met 64-bits webbrowsers"
				LangString 2 ${LANG_ESTONIAN} "kooskõlas 64-bitine veebibrauserite"
				LangString 2 ${LANG_FILIPINO} "katugma sa 64-bit Web Browser"
				LangString 2 ${LANG_FINNISH} "yhteensopiva 64-bittinen selaimet"
				LangString 2 ${LANG_FRENCH} "compatible avec 64 bits Navigateurs Web"
				LangString 2 ${LANG_GERMAN} "mit 64-Bit-Web-Browser kompatibel"
				LangString 2 ${LANG_GREEK} "συμβατό με 64-bit Προγράμματα περιήγησης στο Web"
				LangString 2 ${LANG_GUJARATI} "64-bit વેબ બ્રાઉઝર્સની સાથે સુસંગત"
				LangString 2 ${LANG_HEBREW} "תואם עם דפדפני אינטרנט 64 סיביות"
				LangString 2 ${LANG_HINDI} "64-बिट वेब ब्राउज़रों के साथ संगत"
				LangString 2 ${LANG_HUNGARIAN} "kompatibilis a 64 bites webböngészők"
				LangString 2 ${LANG_INDONESIAN} "kompatibel dengan 64-bit Web Browser"
				LangString 2 ${LANG_ITALIAN} "compatibile con i browser Web a 64 bit"
				LangString 2 ${LANG_JAPANESE} "64ビットのWebブラウザとの互換性"
				LangString 2 ${LANG_KANNADA} "64-ಬಿಟ್ ವೆಬ್ ಬ್ರೌಸರ್"
				LangString 2 ${LANG_KOREAN} "64 비트 웹 브라우저와 호환"
				LangString 2 ${LANG_LATVIAN} "saderīga ar 64-bitu Web pārlūkprogrammas"
				LangString 2 ${LANG_LITHUANIAN} "suderinama su 64 bitų interneto naršyklių"
				LangString 2 ${LANG_MALAY} "serasi dengan 64-bit Pelayar Web"
				LangString 2 ${LANG_MALAYALAM} "64-ബിറ്റ് വെബ് ബ്രൗസറുകളും പൊരുത്തപ്പെടുന്നു"
				LangString 2 ${LANG_MARATHI} "64-बिट वेब ब्राउझर सुसंगत"
				LangString 2 ${LANG_NORWEGIAN} "kompatibel med 64-bits nettlesere"
				LangString 2 ${LANG_FARSI} "سازگار با مرورگرهای وب 64 بیتی"
				LangString 2 ${LANG_POLISH} "kompatybilny z 64-bitowych przeglądarek internetowych"
				LangString 2 ${LANG_PORTUGUESEBR} "compatível com navegadores da Web de 64 bits"
				LangString 2 ${LANG_PORTUGUESE} "compatível com navegadores da Web de 64 bits"
				LangString 2 ${LANG_ROMANIAN} "compatibil cu 64-bit browsere web"
				LangString 2 ${LANG_RUSSIAN} "совместим с 64-битными веб-браузеров"
				LangString 2 ${LANG_SERBIAN} "компатибилан са 64-битним Веб претраживачи"
				LangString 2 ${LANG_SLOVAK} "kompatibilný s 64-bitovými webové prehliadače"
				LangString 2 ${LANG_SLOVENIAN} "združljiv z 64-bitnimi Spletni brskalniki"
				LangString 2 ${LANG_SPANISH} "compatible con los navegadores web de 64 bits"
				LangString 2 ${LANG_SPANISHINTERNATIONAL} "compatible con los navegadores web de 64 bits"
				LangString 2 ${LANG_SWAHILI} "sambamba na 64-bit Browsers Mtandao"
				LangString 2 ${LANG_SWEDISH} "kompatibel med 64-bitars Webbläsare"
				LangString 2 ${LANG_TAMIL} "64-பிட் இணைய உலாவிகளில் இணக்கமானது"
				LangString 2 ${LANG_TELUGU} "64-బిట్ వెబ్ బ్రౌజర్లు అనుకూలంగా"
				LangString 2 ${LANG_THAI} "เข้ากันได้กับเว็บเบราเซอร์ 64 บิต"
				LangString 2 ${LANG_TURKISH} "64-bit Web Tarayıcıları ile uyumlu"
				LangString 2 ${LANG_UKRAINIAN} "сумісний з 64-бітними веб-браузерів"
				LangString 2 ${LANG_VIETNAMESE} "tương thích với 64-bit Trình duyệt Web"
			!else
				LangString 1 ${LANG_ENGLISH} "compatible with $AppID x32"
				LangString 1 ${LANG_ENGLISHAU} "compatible with $AppID x32"
				LangString 1 ${LANG_ENGLISHGB} "compatible with $AppID x32"
				LangString 1 ${LANG_AMHARIC} "compatible with $AppID x32"
				LangString 1 ${LANG_ARABIC} "متوافق مع $AppID بسرعة x32"
				LangString 1 ${LANG_BENGALI} "$AppID x32 সঙ্গে সামঞ্জস্যপূর্ণ"
				LangString 1 ${LANG_BULGARIAN} "съвместима с $AppID x32"
				LangString 1 ${LANG_CATALAN} "compatible amb $AppID x32"
				LangString 1 ${LANG_SIMPCHINESE} "与$AppID X32兼容"
				LangString 1 ${LANG_TRADCHINESE} "與$AppID X32兼容"
				LangString 1 ${LANG_CROATIAN} "kompatibilan s $AppID X32"
				LangString 1 ${LANG_CZECH} "kompatibilní s $AppID x32"
				LangString 1 ${LANG_DANISH} "kompatibel med $AppID x32"
				LangString 1 ${LANG_DUTCH} "compatibel met $AppID x32"
				LangString 1 ${LANG_ESTONIAN} "kooskõlas $AppID x32"
				LangString 1 ${LANG_FILIPINO} "tugma sa $AppID x32"
				LangString 1 ${LANG_FINNISH} "yhteensopiva $AppID x32"
				LangString 1 ${LANG_FRENCH} "compatible avec $AppID x32"
				LangString 1 ${LANG_GERMAN} "mit $AppID x32 kompatibel"
				LangString 1 ${LANG_GREEK} "συμβατό με $AppID x32"
				LangString 1 ${LANG_GUJARATI} "$AppID x32 સાથે સુસંગત"
				LangString 1 ${LANG_HEBREW} "תואם עם $AppID x32"
				LangString 1 ${LANG_HINDI} "$AppID x32 के साथ संगत"
				LangString 1 ${LANG_HUNGARIAN} "kompatibilis $AppID x32"
				LangString 1 ${LANG_INDONESIAN} "kompatibel dengan $AppID x32"
				LangString 1 ${LANG_ITALIAN} "compatibile con $AppID x32"
				LangString 1 ${LANG_JAPANESE} "$AppID X32との互換性"
				LangString 1 ${LANG_KANNADA} "$AppID x32 ಹೊಂದಬಲ್ಲ"
				LangString 1 ${LANG_KOREAN} "$AppID X32과 호환"
				LangString 1 ${LANG_LATVIAN} "savietojams ar $AppID x32"
				LangString 1 ${LANG_LITHUANIAN} "suderinama su $AppID x32"
				LangString 1 ${LANG_MALAY} "serasi dengan $AppID x32"
				LangString 1 ${LANG_MALAYALAM} "$AppID x32 അനുരൂപമായ"
				LangString 1 ${LANG_MARATHI} "$AppID x32 सुसंगत"
				LangString 1 ${LANG_NORWEGIAN} "kompatibel med $AppID x32"
				LangString 1 ${LANG_FARSI} "سازگار با $AppID از X32"
				LangString 1 ${LANG_POLISH} "kompatybilny z $AppID x32"
				LangString 1 ${LANG_PORTUGUESEBR} "compatível com $AppID x32"
				LangString 1 ${LANG_PORTUGUESE} "compatível com $AppID x32"
				LangString 1 ${LANG_ROMANIAN} "compatibil cu $AppID x32"
				LangString 1 ${LANG_RUSSIAN} "совместим с x32 $AppID"
				LangString 1 ${LANG_SERBIAN} "компатибилан са ЈДовнлоадер к32"
				LangString 1 ${LANG_SLOVAK} "kompatibilný s $AppID x32"
				LangString 1 ${LANG_SLOVENIAN} "združljiv z $AppID x32"
				LangString 1 ${LANG_SPANISH} "compatible con $AppID x32"
				LangString 1 ${LANG_SPANISHINTERNATIONAL} "compatible con $AppID x32"
				LangString 1 ${LANG_SWAHILI} "sambamba na $AppID x32"
				LangString 1 ${LANG_SWEDISH} "kompatibel med $AppID x32"
				LangString 1 ${LANG_TAMIL} "$AppID X32 இணக்கமானது"
				LangString 1 ${LANG_TELUGU} "$AppID x32 అనుకూలంగా"
				LangString 1 ${LANG_THAI} "เข้ากันได้กับ $AppID x32"
				LangString 1 ${LANG_TURKISH} "$AppID x32 uyumlu"
				LangString 1 ${LANG_UKRAINIAN} "сумісний з x32 $AppID"
				LangString 1 ${LANG_VIETNAMESE} "tương thích với $AppID x32"
				LangString 2 ${LANG_ENGLISH} "compatible with $AppID x64"
				LangString 2 ${LANG_ENGLISHAU} "compatible with $AppID x64"
				LangString 2 ${LANG_ENGLISHGB} "compatible with $AppID x64"
				LangString 2 ${LANG_AMHARIC} "compatible with $AppID x64"
				LangString 2 ${LANG_ARABIC} "متوافق مع $AppID بسرعة x64"
				LangString 2 ${LANG_BENGALI} "$AppID x64 সঙ্গে সামঞ্জস্যপূর্ণ"
				LangString 2 ${LANG_BULGARIAN} "съвместима с $AppID x64"
				LangString 2 ${LANG_CATALAN} "compatible amb $AppID x64"
				LangString 2 ${LANG_SIMPCHINESE} "与$AppID X64兼容"
				LangString 2 ${LANG_TRADCHINESE} "與$AppID X64兼容"
				LangString 2 ${LANG_CROATIAN} "kompatibilan s $AppID X64"
				LangString 2 ${LANG_CZECH} "kompatibilní s $AppID x64"
				LangString 2 ${LANG_DANISH} "kompatibel med $AppID x64"
				LangString 2 ${LANG_DUTCH} "compatibel met $AppID x64"
				LangString 2 ${LANG_ESTONIAN} "kooskõlas $AppID x64"
				LangString 2 ${LANG_FILIPINO} "tugma sa $AppID x64"
				LangString 2 ${LANG_FINNISH} "yhteensopiva $AppID x64"
				LangString 2 ${LANG_FRENCH} "compatible avec $AppID x64"
				LangString 2 ${LANG_GERMAN} "mit $AppID x64 kompatibel"
				LangString 2 ${LANG_GREEK} "συμβατό με $AppID x64"
				LangString 2 ${LANG_GUJARATI} "$AppID x64 સાથે સુસંગત"
				LangString 2 ${LANG_HEBREW} "תואם עם $AppID x64"
				LangString 2 ${LANG_HINDI} "$AppID x64 के साथ संगत"
				LangString 2 ${LANG_HUNGARIAN} "kompatibilis $AppID x64"
				LangString 2 ${LANG_INDONESIAN} "kompatibel dengan $AppID x64"
				LangString 2 ${LANG_ITALIAN} "compatibile con $AppID x64"
				LangString 2 ${LANG_JAPANESE} "$AppID X64との互換性"
				LangString 2 ${LANG_KANNADA} "$AppID x64 ಹೊಂದಬಲ್ಲ"
				LangString 2 ${LANG_KOREAN} "$AppID X64과 호환"
				LangString 2 ${LANG_LATVIAN} "savietojams ar $AppID x64"
				LangString 2 ${LANG_LITHUANIAN} "suderinama su $AppID x64"
				LangString 2 ${LANG_MALAY} "serasi dengan $AppID x64"
				LangString 2 ${LANG_MALAYALAM} "$AppID x64 അനുരൂപമായ"
				LangString 2 ${LANG_MARATHI} "$AppID x64 सुसंगत"
				LangString 2 ${LANG_NORWEGIAN} "kompatibel med $AppID x64"
				LangString 2 ${LANG_FARSI} "سازگار با $AppID از X64"
				LangString 2 ${LANG_POLISH} "kompatybilny z $AppID x64"
				LangString 2 ${LANG_PORTUGUESEBR} "compatível com $AppID x64"
				LangString 2 ${LANG_PORTUGUESE} "compatível com $AppID x64"
				LangString 2 ${LANG_ROMANIAN} "compatibil cu $AppID x64"
				LangString 2 ${LANG_RUSSIAN} "совместим с x64 $AppID"
				LangString 2 ${LANG_SERBIAN} "компатибилан са ЈДовнлоадер к64"
				LangString 2 ${LANG_SLOVAK} "kompatibilný s $AppID x64"
				LangString 2 ${LANG_SLOVENIAN} "združljiv z $AppID x64"
				LangString 2 ${LANG_SPANISH} "compatible con $AppID x64"
				LangString 2 ${LANG_SPANISHINTERNATIONAL} "compatible con $AppID x64"
				LangString 2 ${LANG_SWAHILI} "sambamba na $AppID x64"
				LangString 2 ${LANG_SWEDISH} "kompatibel med $AppID x64"
				LangString 2 ${LANG_TAMIL} "$AppID X64 இணக்கமானது"
				LangString 2 ${LANG_TELUGU} "$AppID x64 అనుకూలంగా"
				LangString 2 ${LANG_THAI} "เข้ากันได้กับ $AppID x64"
				LangString 2 ${LANG_TURKISH} "$AppID x64 uyumlu"
				LangString 2 ${LANG_UKRAINIAN} "сумісний з x64 $AppID"
				LangString 2 ${LANG_VIETNAMESE} "tương thích với $AppID x64"
			!endif
		!endif
	!else
		LangString 1 ${LANG_AZERBAIJANI} `${CLOSENAME} x32 uyğun`
		LangString 1 ${LANG_BASQUE} `${CLOSENAME} x32 bateragarria`
		LangString 1 ${LANG_BOSNIAN} `kompatibilan s ${CLOSENAME} x32`
		LangString 1 ${LANG_GALICIAN} `compatible con ${CLOSENAME} x32`
		LangString 1 ${LANG_KAZAKH} `${CLOSENAME} x32 үйлесімді`
		LangString 1 ${LANG_KURDISH} `compatible with ${CLOSENAME} x32`
		LangString 1 ${LANG_SERBIANLATIN} `kompatibilan sa ${CLOSENAME} x32`
		LangString 1 ${LANG_ENGLISH} "compatible with ${CLOSENAME} x32"
		LangString 1 ${LANG_ENGLISHAU} "compatible with ${CLOSENAME} x32"
		LangString 1 ${LANG_ENGLISHGB} "compatible with ${CLOSENAME} x32"
		LangString 1 ${LANG_AMHARIC} "compatible with ${CLOSENAME} x32"
		LangString 1 ${LANG_ARABIC} "متوافق مع ${CLOSENAME} بسرعة x32"
		LangString 1 ${LANG_BENGALI} "${CLOSENAME} x32 সঙ্গে সামঞ্জস্যপূর্ণ"
		LangString 1 ${LANG_BULGARIAN} "съвместима с ${CLOSENAME} x32"
		LangString 1 ${LANG_CATALAN} "compatible amb ${CLOSENAME} x32"
		LangString 1 ${LANG_SIMPCHINESE} "与${CLOSENAME} X32兼容"
		LangString 1 ${LANG_TRADCHINESE} "與${CLOSENAME} X32兼容"
		LangString 1 ${LANG_CROATIAN} "kompatibilan s ${CLOSENAME} X32"
		LangString 1 ${LANG_CZECH} "kompatibilní s ${CLOSENAME} x32"
		LangString 1 ${LANG_DANISH} "kompatibel med ${CLOSENAME} x32"
		LangString 1 ${LANG_DUTCH} "compatibel met ${CLOSENAME} x32"
		LangString 1 ${LANG_ESTONIAN} "kooskõlas ${CLOSENAME} x32"
		LangString 1 ${LANG_FILIPINO} "tugma sa ${CLOSENAME} x32"
		LangString 1 ${LANG_FINNISH} "yhteensopiva ${CLOSENAME} x32"
		LangString 1 ${LANG_FRENCH} "compatible avec ${CLOSENAME} x32"
		LangString 1 ${LANG_FRENCHCA} "compatible avec ${CLOSENAME} x32"
		LangString 1 ${LANG_MOROCCAN} "compatible avec ${CLOSENAME} x32"
		LangString 1 ${LANG_GERMAN} "mit ${CLOSENAME} x32 kompatibel"
		LangString 1 ${LANG_GREEK} "συμβατό με ${CLOSENAME} x32"
		LangString 1 ${LANG_GUJARATI} "${CLOSENAME} x32 સાથે સુસંગત"
		LangString 1 ${LANG_HEBREW} "תואם עם ${CLOSENAME} x32"
		LangString 1 ${LANG_HINDI} "${CLOSENAME} x32 के साथ संगत"
		LangString 1 ${LANG_HUNGARIAN} "kompatibilis ${CLOSENAME} x32"
		LangString 1 ${LANG_INDONESIAN} "kompatibel dengan ${CLOSENAME} x32"
		LangString 1 ${LANG_ITALIAN} "compatibile con ${CLOSENAME} x32"
		LangString 1 ${LANG_JAPANESE} "${CLOSENAME} X32との互換性"
		LangString 1 ${LANG_KANNADA} "${CLOSENAME} x32 ಹೊಂದಬಲ್ಲ"
		LangString 1 ${LANG_KOREAN} "${CLOSENAME} X32과 호환"
		LangString 1 ${LANG_LATVIAN} "savietojams ar ${CLOSENAME} x32"
		LangString 1 ${LANG_LITHUANIAN} "suderinama su ${CLOSENAME} x32"
		LangString 1 ${LANG_MALAY} "serasi dengan ${CLOSENAME} x32"
		LangString 1 ${LANG_MALAYALAM} "${CLOSENAME} x32 അനുരൂപമായ"
		LangString 1 ${LANG_MARATHI} "${CLOSENAME} x32 सुसंगत"
		LangString 1 ${LANG_NORWEGIAN} "kompatibel med ${CLOSENAME} x32"
		LangString 1 ${LANG_FARSI} "سازگار با ${CLOSENAME} از X32"
		LangString 1 ${LANG_POLISH} "kompatybilny z ${CLOSENAME} x32"
		LangString 1 ${LANG_PORTUGUESEBR} "compatível com ${CLOSENAME} x32"
		LangString 1 ${LANG_PORTUGUESE} "compatível com ${CLOSENAME} x32"
		LangString 1 ${LANG_ROMANIAN} "compatibil cu ${CLOSENAME} x32"
		LangString 1 ${LANG_RUSSIAN} "совместим с x32 ${CLOSENAME}"
		LangString 1 ${LANG_SERBIAN} "компатибилан са ЈДовнлоадер к32"
		LangString 1 ${LANG_SLOVAK} "kompatibilný s ${CLOSENAME} x32"
		LangString 1 ${LANG_SLOVENIAN} "združljiv z ${CLOSENAME} x32"
		LangString 1 ${LANG_SPANISH} "compatible con ${CLOSENAME} x32"
		LangString 1 ${LANG_SPANISHINTERNATIONAL} "compatible con ${CLOSENAME} x32"
		LangString 1 ${LANG_SWAHILI} "sambamba na ${CLOSENAME} x32"
		LangString 1 ${LANG_SWEDISH} "kompatibel med ${CLOSENAME} x32"
		LangString 1 ${LANG_TAMIL} "${CLOSENAME} X32 இணக்கமானது"
		LangString 1 ${LANG_TELUGU} "${CLOSENAME} x32 అనుకూలంగా"
		LangString 1 ${LANG_THAI} "เข้ากันได้กับ ${CLOSENAME} x32"
		LangString 1 ${LANG_TURKISH} "${CLOSENAME} x32 uyumlu"
		LangString 1 ${LANG_UKRAINIAN} "сумісний з x32 ${CLOSENAME}"
		LangString 1 ${LANG_VIETNAMESE} "tương thích với ${CLOSENAME} x32"
		LangString 2 ${LANG_AZERBAIJANI} `${CLOSENAME} x64 uyğun`
		LangString 2 ${LANG_BASQUE} `${CLOSENAME} x64 bateragarria`
		LangString 2 ${LANG_BOSNIAN} `kompatibilan s ${CLOSENAME} x64`
		LangString 2 ${LANG_GALICIAN} `compatible con ${CLOSENAME} x64`
		LangString 2 ${LANG_KAZAKH} `${CLOSENAME} x64 үйлесімді`
		LangString 2 ${LANG_KURDISH} `compatible with ${CLOSENAME} x64`
		LangString 2 ${LANG_SERBIANLATIN} `kompatibilan sa ${CLOSENAME} x64`
		LangString 2 ${LANG_ENGLISH} "compatible with ${CLOSENAME} x64"
		LangString 2 ${LANG_ENGLISHAU} "compatible with ${CLOSENAME} x64"
		LangString 2 ${LANG_ENGLISHGB} "compatible with ${CLOSENAME} x64"
		LangString 2 ${LANG_AMHARIC} "compatible with ${CLOSENAME} x64"
		LangString 2 ${LANG_ARABIC} "متوافق مع ${CLOSENAME} بسرعة x64"
		LangString 2 ${LANG_BENGALI} "${CLOSENAME} x64 সঙ্গে সামঞ্জস্যপূর্ণ"
		LangString 2 ${LANG_BULGARIAN} "съвместима с ${CLOSENAME} x64"
		LangString 2 ${LANG_CATALAN} "compatible amb ${CLOSENAME} x64"
		LangString 2 ${LANG_SIMPCHINESE} "与${CLOSENAME} X64兼容"
		LangString 2 ${LANG_TRADCHINESE} "與${CLOSENAME} X64兼容"
		LangString 2 ${LANG_CROATIAN} "kompatibilan s ${CLOSENAME} X64"
		LangString 2 ${LANG_CZECH} "kompatibilní s ${CLOSENAME} x64"
		LangString 2 ${LANG_DANISH} "kompatibel med ${CLOSENAME} x64"
		LangString 2 ${LANG_DUTCH} "compatibel met ${CLOSENAME} x64"
		LangString 2 ${LANG_ESTONIAN} "kooskõlas ${CLOSENAME} x64"
		LangString 2 ${LANG_FILIPINO} "tugma sa ${CLOSENAME} x64"
		LangString 2 ${LANG_FINNISH} "yhteensopiva ${CLOSENAME} x64"
		LangString 2 ${LANG_FRENCH} "compatible avec ${CLOSENAME} x64"
		LangString 2 ${LANG_FRENCHCA} "compatible avec ${CLOSENAME} x64"
		LangString 2 ${LANG_MOROCCAN} "compatible avec ${CLOSENAME} x64"
		LangString 2 ${LANG_GERMAN} "mit ${CLOSENAME} x64 kompatibel"
		LangString 2 ${LANG_GREEK} "συμβατό με ${CLOSENAME} x64"
		LangString 2 ${LANG_GUJARATI} "${CLOSENAME} x64 સાથે સુસંગત"
		LangString 2 ${LANG_HEBREW} "תואם עם ${CLOSENAME} x64"
		LangString 2 ${LANG_HINDI} "${CLOSENAME} x64 के साथ संगत"
		LangString 2 ${LANG_HUNGARIAN} "kompatibilis ${CLOSENAME} x64"
		LangString 2 ${LANG_INDONESIAN} "kompatibel dengan ${CLOSENAME} x64"
		LangString 2 ${LANG_ITALIAN} "compatibile con ${CLOSENAME} x64"
		LangString 2 ${LANG_JAPANESE} "${CLOSENAME} X64との互換性"
		LangString 2 ${LANG_KANNADA} "${CLOSENAME} x64 ಹೊಂದಬಲ್ಲ"
		LangString 2 ${LANG_KOREAN} "${CLOSENAME} X64과 호환"
		LangString 2 ${LANG_LATVIAN} "savietojams ar ${CLOSENAME} x64"
		LangString 2 ${LANG_LITHUANIAN} "suderinama su ${CLOSENAME} x64"
		LangString 2 ${LANG_MALAY} "serasi dengan ${CLOSENAME} x64"
		LangString 2 ${LANG_MALAYALAM} "${CLOSENAME} x64 അനുരൂപമായ"
		LangString 2 ${LANG_MARATHI} "${CLOSENAME} x64 सुसंगत"
		LangString 2 ${LANG_NORWEGIAN} "kompatibel med ${CLOSENAME} x64"
		LangString 2 ${LANG_FARSI} "سازگار با ${CLOSENAME} از X64"
		LangString 2 ${LANG_POLISH} "kompatybilny z ${CLOSENAME} x64"
		LangString 2 ${LANG_PORTUGUESEBR} "compatível com ${CLOSENAME} x64"
		LangString 2 ${LANG_PORTUGUESE} "compatível com ${CLOSENAME} x64"
		LangString 2 ${LANG_ROMANIAN} "compatibil cu ${CLOSENAME} x64"
		LangString 2 ${LANG_RUSSIAN} "совместим с x64 ${CLOSENAME}"
		LangString 2 ${LANG_SERBIAN} "компатибилан са ЈДовнлоадер к64"
		LangString 2 ${LANG_SLOVAK} "kompatibilný s ${CLOSENAME} x64"
		LangString 2 ${LANG_SLOVENIAN} "združljiv z ${CLOSENAME} x64"
		LangString 2 ${LANG_SPANISH} "compatible con ${CLOSENAME} x64"
		LangString 2 ${LANG_SPANISHINTERNATIONAL} "compatible con ${CLOSENAME} x64"
		LangString 2 ${LANG_SWAHILI} "sambamba na ${CLOSENAME} x64"
		LangString 2 ${LANG_SWEDISH} "kompatibel med ${CLOSENAME} x64"
		LangString 2 ${LANG_TAMIL} "${CLOSENAME} X64 இணக்கமானது"
		LangString 2 ${LANG_TELUGU} "${CLOSENAME} x64 అనుకూలంగా"
		LangString 2 ${LANG_THAI} "เข้ากันได้กับ ${CLOSENAME} x64"
		LangString 2 ${LANG_TURKISH} "${CLOSENAME} x64 uyumlu"
		LangString 2 ${LANG_UKRAINIAN} "сумісний з x64 ${CLOSENAME}"
		LangString 2 ${LANG_VIETNAMESE} "tương thích với ${CLOSENAME} x64"
	!endif
	LangString m ${LANG_ENGLISH} "Include all available languages."
	LangString m ${LANG_ENGLISHGB} "Include all available languages."
	LangString m ${LANG_ARABIC} "يشمل جميع اللغات المتاحة."
	LangString m ${LANG_SIMPCHINESE} "包括所有可用的语言。"
	LangString m ${LANG_TRADCHINESE} "包括所有可用的語言。"
	LangString m ${LANG_CZECH} "Včetně všech dostupných jazycích."
	LangString m ${LANG_DANISH} "Medtag alle tilgængelige sprog."
	LangString m ${LANG_DUTCH} "Inclusief alle beschikbare talen."
	LangString m ${LANG_FINNISH} "Sisällytä kaikki käytettävissä olevat kielet."
	LangString m ${LANG_FRENCH} "Inclure toutes les langues disponibles."
	LangString m ${LANG_FRENCHCA} "Inclure toutes les langues disponibles."
	LangString m ${LANG_MOROCCAN} "Inclure toutes les langues disponibles."
	LangString m ${LANG_GERMAN} "Alle verfügbaren Sprachen."
	LangString m ${LANG_HEBREW} "כולל את כל שפות הזמינות."
	LangString m ${LANG_HUNGARIAN} "Az összes rendelkezésre álló nyelven."
	LangString m ${LANG_ITALIAN} "Include tutte le lingue disponibili."
	LangString m ${LANG_JAPANESE} "利用可能なすべての言語を含めます。"
	LangString m ${LANG_KOREAN} "사용 가능한 모든 언어를 포함합니다."
	LangString m ${LANG_NORWEGIAN} "Ta med alle tilgjengelige språk."
	LangString m ${LANG_POLISH} "Obejmują wszystkie dostępne języki."
	LangString m ${LANG_PORTUGUESEBR} "Incluir todos os idiomas disponíveis."
	LangString m ${LANG_RUSSIAN} "Включить все доступные языки."
	LangString m ${LANG_SPANISH} "Incluir todos los idiomas disponibles."
	LangString m ${LANG_SPANISHINTERNATIONAL} "Incluir todos los idiomas disponibles."
	LangString m ${LANG_SWEDISH} "Inkludera alla tillgängliga språk."
	LangString m ${LANG_TURKISH} "Mevcut tüm dilleri ekleyin."
	LangString m ${LANG_UKRAINIAN} "Включити всі доступні мови."
	!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
		!insertmacro MUI_DESCRIPTION_TEXT ${MAINSECTIONIDX} "${MAINSECTIONDESCRIPTION}"
		!ifdef OPTIONALSECTION1TITLE
			!ifdef NON-SPECIFIC-PLUGIN
				!ifdef COMMONFILESPLUGIN
					!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION1} "$(86)"
				!else
					!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION1} "$(1)"
				!endif
			!else
				!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION1} "$(86)"
			!endif
		!endif
		!ifdef OPTIONALSECTION2TITLE
			!ifdef NON-SPECIFIC-PLUGIN
				!ifdef COMMONFILESPLUGIN
					!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION2} "$(64)"
				!else
					!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION2} "$(2)"
				!endif
			!else
				!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION2} "$(64)"
			!endif
		!endif
		!ifdef OPTIONALSECTION3TITLE
			!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION3}     `$(m)`
		!endif
		!ifdef OPTIONALSECTION4TITLE
			!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION4}     ""
		!endif
		!ifdef OPTIONALSECTION5TITLE
			!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION5}     ""
		!endif
		!ifdef OPTIONALSECTION6TITLE
			!insertmacro MUI_DESCRIPTION_TEXT ${OPTIONALSECTION6}     ""
		!endif
	!insertmacro MUI_FUNCTION_DESCRIPTION_END
!endif

;=== set custom sizes
!ifdef MAINSECTIONTITLE
	!ifdef CUSTOMSIZE
		Function .onSelChange
			Push $1
			Push $2
			Push $3
			SectionGetFlags ${OPTIONALSECTION1} $1
			SectionGetFlags ${OPTIONALSECTION2} $2
			SectionGetFlags ${OPTIONALSECTION3} $3
			IntOp $1 $1 & ${SF_SELECTED}
			IntOp $2 $2 & ${SF_SELECTED}
			IntOp $3 $3 & ${SF_SELECTED}
			${If} $3 >= ${SF_SELECTED}
			${AndIf} $1 >= ${SF_SELECTED}
			${AndIf} $2 >= ${SF_SELECTED}
				SectionSetSize ${MAINSECTIONIDX} ${3264LANG}
			${ElseIf} $3 >= ${SF_SELECTED}
			${AndIf} $1 >= ${SF_SELECTED}
			${AndIf} $2 != ${SF_SELECTED}
				SectionSetSize ${MAINSECTIONIDX} ${32LANG}
			${ElseIf} $3 >= ${SF_SELECTED}
			${AndIf} $1 != ${SF_SELECTED}
			${AndIf} $2 >= ${SF_SELECTED}
				SectionSetSize ${MAINSECTIONIDX} ${64LANG}
			${ElseIf} $3 != ${SF_SELECTED}
			${AndIf} $1 >= ${SF_SELECTED}
			${AndIf} $2 >= ${SF_SELECTED}
				SectionSetSize ${MAINSECTIONIDX} ${3264}
			${ElseIf} $3 != ${SF_SELECTED}
			${AndIf} $1 >= ${SF_SELECTED}
			${AndIf} $2 != ${SF_SELECTED}
				SectionSetSize ${MAINSECTIONIDX} ${32}
			${ElseIf} $3 != ${SF_SELECTED}
			${AndIf} $1 != ${SF_SELECTED}
			${AndIf} $2 >= ${SF_SELECTED}
				SectionSetSize ${MAINSECTIONIDX} ${64}
			${ElseIf} $1 != ${SF_SELECTED}
			${AndIf} $2 != ${SF_SELECTED}
				SectionSetSize ${MAINSECTIONIDX} ${DEFAULTSIZE}
			${EndIf}
			Pop $3
			Pop $2
			Pop $1
		FunctionEnd
	!endif
!endif
!ifdef FORCEONLYONESELECTION
Function .onSelChange
	Push $0
	SectionGetFlags $1 $0
	IntOp $0 $0 & ${SECTION_OFF}
	SectionSetFlags $1 $0
	Push $2
	StrCpy $2 $1
	SectionGetFlags ${OPTIONALSECTION1} $0
	IntOp $0 $0 & ${SECTION_ON}
	IntCmp $0 ${SECTION_ON} 0 +2 +2
	StrCpy $1 ${OPTIONALSECTION1}
	SectionGetFlags ${OPTIONALSECTION2} $0
	IntOp $0 $0 & ${SECTION_ON}
	IntCmp $0 ${SECTION_ON} 0 +2 +2
	StrCpy $1 ${OPTIONALSECTION2}
	SectionGetFlags ${OPTIONALSECTION3} $0
	IntOp $0 $0 & ${SECTION_ON}
	IntCmp $0 ${SECTION_ON} 0 +2 +2
	StrCpy $1 ${OPTIONALSECTION3}
	SectionGetFlags ${OPTIONALSECTION4} $0
	IntOp $0 $0 & ${SECTION_ON}
	IntCmp $0 ${SECTION_ON} 0 +2 +2
	StrCpy $1 ${OPTIONALSECTION4}
	StrCmp $2 $1 0 +4
	SectionGetFlags $1 $0
	IntOp $0 $0 | ${SECTION_ON}
	SectionSetFlags $1 $0
	Pop $2
	Pop $0
FunctionEnd
!endif
Function .onInstFailed
	!ifdef COPYLOCALFILES
		${reg::Unload}
	!endif
	RMDir $INSTDIR ;remove directory if empty
FunctionEnd

!ifdef COPYLOCALFILES
	Function .onInstSuccess
		${reg::Unload}
	FunctionEnd
	Function CustomAbortFunction
		${reg::Unload}
	FunctionEnd
!endif